// SauerMod - MODENGINE - Engine Extensions by Quinton Reeves
// This extends the engine core.

#include "pch.h"
#include "engine.h"

VAR(sauermod, 1, 1, -1); // for scripts
VARP(online, 0, 1, 1); // if so, then enable certain actions

void _grabmouse(int n)
{
	SDL_WM_GrabInput(n ? SDL_GRAB_ON : SDL_GRAB_OFF);
	keyrepeat(n ? false : true);
	SDL_ShowCursor(n ? 0 : 1);
}
VARF(grabmouse, 0, 1, 1, _grabmouse(grabmouse););

bool modexec(char *name, bool quiet)
{
	s_sprintfd(s)("data/%s/%s", cl->gameident(), name);
	if (quiet) { return execfile(s); }
	else { exec(s); return true; }
}

FILE *modfopen(char *name, char *mode)
{
	s_sprintfd(s)("data/%s/%s", cl->gameident(), name);
	return openfile(s, mode);
}

int modgetint(gzFile f)
{
	int t;
	gzread(f, &t, sizeof(int));
	endianswap(&t, sizeof(int), 1);
	return t;
}

void modputint(gzFile f, int x)
{
	int t = (int)x;
		endianswap(&t, sizeof(int), 1);
		gzwrite(f, &t, sizeof(int));
}

bool modoption(char *opt)
{
	switch(opt[1])
	{
		default:
			return false;
			break;
	}
}

void gameident() { result(cl->gameident()); }
COMMAND(gameident, "");

void gamepakdir() { result(cl->gamepakdir()); }
COMMAND(gamepakdir, "");

void gamedefaultmap() { result(cl->defaultmap()); }
COMMAND(gamedefaultmap, "");

void gamesavedconfig() { result(cl->savedconfig()); }
COMMAND(gamesavedconfig, "");

void gamedefaultconfig() { result(cl->defaultconfig()); }
COMMAND(gamedefaultconfig, "");

void gameautoexec() { result(cl->autoexec()); }
COMMAND(gameautoexec, "");

void gamesavedservers() { result(cl->savedservers()); }
COMMAND(gamesavedservers, "");

void modconfig()
{
	// engine and overridables
	exec("data/keymap.cfg");
	exec("data/stdedit.cfg");
	exec("data/sauermod.cfg");

	exec("data/brush.cfg");
	execfile("mybrushes.cfg");

	// the rest is specific to game - makes things cleaner
	modexec("menus.cfg");
	modexec("sounds.cfg");

	if(cl->savedservers()) modexec(cl->savedservers(), true);

	persistidents = true;

	modexec(cl->defaultconfig()); // then only fpsgame asks for regular ol' default
	modexec(cl->savedconfig());
	modexec(cl->autoexec());

	persistidents = false;

	modexec("game.cfg");

	persistidents = true;
}

char *modgettitle() { return hdr.maptitle; }

int modgetmat(float x, float y, float z)
{
	cube &c = lookupcube((int)x, (int)y, (int)z);
	
	if (c.ext) return c.ext->material;
	return MAT_AIR;
}
