// SauerMod - MODENGINE - Engine Extensions by Quinton Reeves
// This extends renderparticles.cpp

void part_textf(const vec &s, char *t, bool moving, int fade, int color, ...)
{
	s_sprintfdlv(str, color, t);
	s_sprintfd(buf)("@%s", str);
	part_text(s, buf, moving, fade, color);
}

void part_text(const vec &s, char *t, bool moving, int fade, int color)
{
	if(!particletext || camera1->o.dist(s) > 128) return;
	newparticle(s, vec(0, 0, 1), fade, moving ? 9 : 11, color)->text = newstring(t);
}

void part_splash(int type, int num, int fade, const vec &p, int color)
{
	if(camera1->o.dist(p) > maxparticledistance) return;
	loopi(num)
	{
		const int radius = (type==6 || type == 17) ? 50 : 150;	
		int x, y, z;
		do
		{
			x = rnd(radius*2)-radius;
			y = rnd(radius*2)-radius;
			z = rnd(radius*2)-radius;
		}
		while(x*x+y*y+z*z>radius*radius);
		vec tmp = vec((float)x, (float)y, (float)z);
		newparticle(p, tmp, rnd(fade*3)+1, type, color);
	}
}

void part_trail(int type, int fade, const vec &s, const vec &e, int color)
{
	vec v;
	float d = e.dist(s, v);
	v.div(d*2);
	vec p = s;
	loopi((int)d*2)
	{
		p.add(v);
		vec tmp = vec(float(rnd(11)-5), float(rnd(11)-5), float(rnd(11)-5));
		newparticle(p, tmp, rnd(fade)+fade, type, color);
	}
}

void part_meter(const vec &s, float val, int type, int fade, int color)
{
	newparticle(s, vec(0, 0, 1), fade, type, color)->val = val;
}

void part_flare(const vec &p, const vec &dest, int fade, int type, int color)
{
	newparticle(p, dest, fade, type, color);
}

void part_fireball(const vec &dest, float max, int type, int color)
{
	int maxsize = int(max) - 4;
	newparticle(dest, vec(0, 0, 1), maxsize*25, type, color)->val = maxsize;
}

void part_firerad(const vec &dest, float size, int type, int color)
{
	newparticle(dest, vec(0, 0, 1), int(size), type, color)->val = int(size)+100;
}

void part_spawn(const vec &o, const vec &v, float z, uchar type, int amt, int fade, int color)
{
	loopi(amt)
	{
		vec w(rnd(int(v.x*2))-int(v.x), rnd(int(v.y*2))-int(v.y), rnd(int(v.z*2))-int(v.z)+z);
		w.add(o);
		part_splash(type, 1, fade, w, color);
	}
}
