// SauerMod - MODENGINE - Engine Extensions by Quinton Reeves
// This extends rendertext.cpp

void draw_textx(const char *fstr, int left, int top, int r, int g, int b, int a, int align, ...)
{
	s_sprintfdlv(str, align, fstr);

	int x = left, y = top, width = text_width(str);
	
	switch (align)
	{
		case AL_CENTER:
			x -= width/2;
			break;
		case AL_RIGHT:
			x -= width;
			break;
		default:
			break;
	}
	draw_text(str, x, y, r, g, b, a);
}

void draw_text(const char *str, int left, int top, int r, int g, int b, int a)
{
	if(!curfont) return;

	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glBindTexture(GL_TEXTURE_2D, curfont->tex->gl);

	static bvec colorstack[8];
	bvec color(r, g, b);
	int colorpos = 0;

	if (a == 255) a = int(255.f*(hudblend*0.01f));
		
	glBegin(GL_QUADS);
	glColor4ub(r, g, b, a);
 	loopj(2)
 	{
		if (j) glColor4ub(r, g, b, a);
		else  glColor4ub(0, 0, 0, a);

		int off = (j ? -2 : 2);
		int x = left + off;
		int y = top + off;

		int i;

		for (i = 0; str[i] != 0; i++)
		{
			int c = str[i];
			if(c=='\t') { x = ((x-left-off+PIXELTAB)/PIXELTAB)*PIXELTAB+left+off; continue; }
			if(c=='\f')
			{
				if (j)
				{
					switch(str[++i])
					{
						case '0': color = bvec( 64, 255, 128); break;	// green: player talk
						case '1': color = bvec( 96, 160, 255); break;	// blue: "echo" command
						case '2': color = bvec(255, 192,  64); break;	// yellow: gameplay messages 
						case '3': color = bvec(255,  64,  64); break;	// red: important errors
						case '4': color = bvec(128, 128, 128); break;	// gray
						case '5': color = bvec(192,  64, 192); break;	// magenta
						case '6': color = bvec(255, 128,	0); break;	// orange
						case 's': // save color
							if((size_t)colorpos<sizeof(colorstack)/sizeof(colorstack[0])) colorstack[colorpos++] = color;
							continue;
						case 'r': // restore color
							if(colorpos<=0) continue;
							color = colorstack[--colorpos];
							break; 
						default: color = bvec(r, g, b); break;		  // white: everything else
					}				
					glColor4ub(color.x, color.y, color.z, a);
				}
				else { i++; continue; } // shadow
			}
			if(c==' ') { x += curfont->defaultw; continue; }
			c -= 33;
			if(!curfont->chars.inrange(c)) continue;
			
			font::charinfo &info = curfont->chars[c];
			float tc_left	= (info.x + curfont->offsetx) / float(curfont->tex->xs);
			float tc_top	 = (info.y + curfont->offsety) / float(curfont->tex->ys);
			float tc_right	= (info.x + info.w + curfont->offsetw) / float(curfont->tex->xs);
			float tc_bottom  = (info.y + info.h + curfont->offseth) / float(curfont->tex->ys);
	
			glTexCoord2f(tc_left,  tc_top	); glVertex2i(x,		  y);
			glTexCoord2f(tc_right, tc_top	); glVertex2i(x + info.w, y);
			glTexCoord2f(tc_right, tc_bottom); glVertex2i(x + info.w, y + info.h);
			glTexCoord2f(tc_left,  tc_bottom); glVertex2i(x,		  y + info.h);
			
			xtraverts += 4;
			x += info.w + 1;
		}
	}
	glEnd();
}

static vector<font> fontstack;

bool pushfont(char *name)
{
	if (curfont) fontstack.add(*curfont);
	return setfont(name);
}

bool popfont(int num)
{
	int n = fontstack.length();

	loopi(num)
	{
		if (n <= 0) break;
		fontstack.remove(--n);
	}
	return (n != fontstack.length());
}
