// console message types

enum
{
	CON_GAMEINFO = 1<<8, //ie, A to blah, D to blah
	CON_COLLECT = 1<<9, //ie, collecting an item
	CON_KILL = 1<<10 //just when an enemy is defeated :P
};

enum                            // static entity types
{
	NOTUSED = ET_EMPTY,         // entity slot not in use in map
	LIGHT = ET_LIGHT,           // lightsource, attr1 = radius, attr2 = intensity
	MAPMODEL = ET_MAPMODEL,     // attr1 = angle, attr2 = idx
	PLAYERSTART,                // attr1 = angle, attr2 = team
	ENVMAP = ET_ENVMAP,         // attr1 = radius
	PARTICLES = ET_PARTICLES,
	MAPSOUND = ET_SOUND,
	SPOTLIGHT = ET_SPOTLIGHT,
	BOX, //attr1 = yaw, attr2 = model, attr3 = script, attr4 = pickup
	PICKUP, //attr1 = itemtype, attr2 = item, as defined in script
	ENEMY, //attr1 = yaw, attr2 = enemy, as defined is a script, attr3 = first waypoint
	WAYPOINT, //attr1 = number, attr2 and attr3 is linked waypoints, as long as they're above 0, an enemy will head to that specific waypoint
	TELEPORT, //attr1 = teledest, attr2 = radius (0 = 16), attr3 = model
	TELEDEST, //attr1 = yaw, attr2 = from
	CHECKPOINT, //attr1 = yaw, attr2 = radius, attr3 = model
	JUMPPAD, //attr1 = Z, attr2 = Y, attr3 = X, attr4 = radius
	PLATFORM, //attr1 = yaw, attr2 = model, attr3 = route, attr4 = speed
	PLATFORMROUTE, //attr1 = route, attr2 = linkedent1, attr3 = linkedent2
	CAMERA, //attr1 = number, attr2 = yaw, attr3 = pitch, attr4 = distance
	AXIS, //attr1 == 0 == manual, else automatic oneway switch, attr2 = axis script, ie camera change //switches the player's yaw
	MAXENTTYPES
};

enum
{
	PICKUP_COIN = 0,
	PICKUP_WEAPON,
	PICKUP_ARMOUR,
	PICKUP_HEALTH,
	PICKUP_TIME,
	PICKUP_LIVES
};

enum //armour : if armour or a weapon is equipped, lose it instead of health
{
	ARM_NONE = 0,
	ARM_PLAIN, //no special abbilities;
	ARM_ATTRACT, //quadruples pickup range of well.. pickups
	ARM_FLY //gravity is nullified, the player can fly up or down
};

enum //projectiles, try and extend further
{
	PROJ_NONE = 0,
	PROJ_FIST,
	PROJ_BOMB,
	PROJ_FIREBALL,
	PROJ_ROCKET
};

//object structs, mdl is representation model

struct coinpickup
{
	const char *mdl;
	int amount;
};

struct weaponpickup
{
	const char *mdl, *attachmdl;
	int projectile, sound;	
};

struct armourpickup
{
	const char *mdl, *attachmdl;
	int type;
};

struct healthpickup
{
	const char *mdl;
	int amount; //max at 2
};

struct timepickup
{
	const char *mdl;
	int amount; //in seconds
};

struct lifepickup
{
	const char *mdl;
	int amount;
};

struct sspentity : extentity {}; //extend with additional properties if needed

enum
{
    S_JUMP = 0, S_LAND, S_UNUSED, S_TELEPORT, S_SPLASH1, S_SPLASH2, S_CG, 
    S_RLFIRE, S_RUMBLE, S_JUMPPAD, S_WEAPLOAD, S_ITEMAMMO, S_ITEMHEALTH, 
    S_ITEMARMOUR, S_ITEMPUP, S_ITEMSPAWN,  S_NOAMMO, S_PUPOUT, 
    S_PAIN1, S_PAIN2, S_PAIN3, S_PAIN4, S_PAIN5, S_PAIN6, 
    S_DIE1, S_DIE2, 
    S_FLAUNCH, S_FEXPLODE, 
    S_SG, S_PUNCH1, 
    S_GRUNT1, S_GRUNT2, S_RLHIT, 
    S_PAINO, 
    S_PAINR, S_DEATHR, 
    S_PAINE, S_DEATHE, 
    S_PAINS, S_DEATHS, 
    S_PAINB, S_DEATHB, 
    S_PAINP, S_PIGGR2, 
    S_PAINH, S_DEATHH, 
    S_PAIND, S_DEATHD, 
    S_PIGR1, S_ICEBALL, S_SLIMEBALL, S_PISTOL, 
 
    S_V_BASECAP, S_V_BASELOST, 
    S_V_FIGHT, 
    S_V_BOOST, S_V_BOOST10, 
    S_V_QUAD, S_V_QUAD10, 
    S_V_RESPAWNPOINT, 

    S_FLAGPICKUP,
    S_FLAGDROP,
    S_FLAGRETURN,
    S_FLAGSCORE,
    S_FLAGRESET,

    S_BURN
};

struct sspstate
{
	int health, maxhealth;
	int armour, armourvec;
	int quadmillis, powerupmillis;
	int gunselect, gunwait; //gunselect, weapon vector(i-1);

	sspstate() : maxhealth(3) {}


	void respawn()
	{
		health = 1;
		armour = 0;
		armourvec = -1;
		quadmillis = 0;
		powerupmillis = 0;
		gunselect = -1;
		gunwait = 0;
	}
};

struct sspent : dynent, sspstate
{   
	int weight;                         // affects the effectiveness of hitpush
	int lifesequence;                   // sequence id for each respawn, used in damage test
	int lastpain;
	int lastaction;
	bool attacking;
	int lastpickupmillis;
	int powerup;
	editinfo *edit;
	float deltayaw, deltapitch, newyaw, newpitch;
	int lives, coins, checkpoint;

	string name, team;

	sspent() : weight(100), lifesequence(0), lastpain(-2000)/* prevents invulnerability when starting */, edit(NULL), lives(5), coins(0) { name[0] = team[0] = 0; maxspeed = 80; respawn(); }
	~sspent() { freeeditinfo(edit); }

	void respawn()
	{
		dynent::reset();
		sspstate::respawn();
		lastaction = 0;
		attacking = false;
		lastpickupmillis = 0;
		powerup = -1;
	}
};

struct enemy //enemy declaration
{
	const char *mdl;
	int health, speed, painsound, diesound;
	
	enemy(char *_mdl, int *_hlt, int *_spd, int *_ps, int *_ds) : mdl(_mdl), health(*_hlt), speed(*_spd), painsound(*_ps), diesound(*_ds) {}
};

