struct ssprender
{
	sspclient &cl;
	ssprender(sspclient &_cl) : cl(_cl) {}
	
	void renderplayer(sspent *d, const char *mdl)
	{
		int lastaction = d->lastaction,
			anim = d->gunselect ? ANIM_SHOOT : ANIM_PUNCH,
			delay = 300;
			
		if(cl.intermission && d->state!=CS_DEAD)
		{
			if (cl.secsremain)
				anim = ANIM_WIN|ANIM_LOOP;
			else
				anim = ANIM_LOSE|ANIM_LOOP;
		}
		modelattach a[4];
		int ai = 0;
		if(d->state==CS_ALIVE)
		{
			if(cl.armourpickups.inrange(d->gunselect))
			{
				a[ai].m = NULL;
				a[ai].name = cl.weaponpickups[d->gunselect].attachmdl;
				a[ai].tag = "tag_weapon";
				a[ai].anim = ANIM_VWEP|ANIM_LOOP;
				a[ai].basetime = 0;
				ai++;
			}
			if(cl.armourpickups.inrange(d->armourvec))
			{
				a[ai].m = NULL;
				a[ai].name = cl.armourpickups[d->armourvec].attachmdl;
				a[ai].tag = "tag_shield";
				a[ai].anim = ANIM_VWEP|ANIM_LOOP;
				a[ai].basetime = 0;
				ai++;	
			}
			if(d->powerup>=0)
			{
				//TODO
				//ai++;
			}
		}
		a[ai].name = NULL;
		
		if(d->lastpain + 2000 > cl.lastmillis && (cl.lastmillis % 100) > 50) return; //flicker if hurt
		renderclient(d, mdl, a[0].name ? a : NULL, anim, delay, lastaction, cl.intermission ? 0 : d->lastpain);
	}
	
	void rendergame()
	{
		startmodelbatches();
		if(isthirdperson()) renderplayer(cl.player1, "rc");
		cl.sm.render();
		cl.et.renderentities();
		endmodelbatches();
	}
};
