#include "rpggame.h"

namespace game
{
	string clientmap;
	rpgent *player1 = NULL;
	bool transfer = false;
	vector<rpgent *> rpgobjs;
	rpgent *selected = NULL; //this is the ent your cursor is currently hovering over
	rpgent *lastcreated;

	ICOMMAND(map, "s", (char *s), load_world(s));
	VARFP(rpgobjdist, 64, 512, 4096,
		if(rpgobjdist > rpgobj::rpgobjupdatedist)
			rpgobj::rpgobjupdatedist = rpgobjdist;
	);

	const char *getclientmap() { return clientmap; }
	void edittrigger(const selinfo &sel, int op, int arg1, int arg2, int arg3) {}

	void initclient()
	{
		loopv(entities::ents)
		{
			if(entities::ents[i]->type == PLAYERSTART)
			{
				entities::spawnfroment(i);
				return;
			}
		}

		rpgobjs.add(new rpgent(DEFAULTMODEL));
		player1 = rpgobjs[rpgobjs.length()-1]; //should be 0...
		player1->respawn();
		player1->name = newstring("player");
		lastcreated = player1;
		defformatstring(ds)("spawn_player");
		execute(ds);
	}

	void spawnplayer(rpgent *d)
	{
		findplayerspawn(d, d==player1 && d->spawn>=0 ? d->spawn : -1);
	}

	void respawnself(bool death = false)
	{
		player1->respawn(death);
		spawnplayer(player1);
	}

	const char *defaultcrosshair(int crosshair)
	{
		switch(crosshair)
		{
			case CROSS_PICKUP:	return "data/pickup";		// Pickup
			case CROSS_TALK:	return "data/talk";		// Talk
			case CROSS_EDIT:	return "data/edit";		// Edit
			default:		return "data/crosshair";	// Default
		}
	}

	int selectcrosshair(float &r, float &g, float &b)
	{
		if(editmode) { r = g = 0.5f; b = 1; return CROSS_EDIT; }
		if(selected)
		{
			if(selected->character && selected->state != CS_DEAD /* && friendly */) return CROSS_TALK;
			else if(selected->etype == ENT_ITEM || selected->etype == ENT_SPELL || selected->etype == ENT_OBJECT ||
				selected->state == CS_DEAD) return CROSS_PICKUP;
		}
		return CROSS_DEFAULT;
	}

	int clipconsole(int w, int h) {return 0;} //adjust when the hud comes in

	float abovegameplayhud() {return gui::guisopen() ? 1 : 0.875;}

	void quad(int x, int y, int xs, int ys)
	{
		glBegin(GL_QUADS);
		glTexCoord2f(0, 0); glVertex2i(x,    y);
		glTexCoord2f(1, 0); glVertex2i(x+xs, y);
		glTexCoord2f(1, 1); glVertex2i(x+xs, y+ys);
		glTexCoord2f(0, 1); glVertex2i(x,    y+ys);
		glEnd();
	}

	int entcolour(rpgent *d)
	{
		switch(d->etype)
		{
			case ENT_CHAR:
				//TODO, make it vary between the character's relative friendliness to the player
				return 0x00FF00;
			case ENT_ITEM:
			case ENT_SPELL:
				return 0xAFAF00;
			case ENT_OBJECT:
				return 0x7F00FF;
			default:
				return 0;
		}
	}

	const char *geteffectdescription(status &s)
	{
		switch(s.type)
		{
			case STATUS_HEALTH:
				if(s.strength >= 0) return "gradually restores health to the affected";
				else return "gradually deals damage to the aflicted, negatable by your resistances";
			case STATUS_MOVE:
				if(s.strength >= 0) return "movespeed is boosted temporarily";
				else return "movespeed is lowered temporarily";
			case STATUS_STRENGTH:
				if(s.strength >= 0) return "strength is boosted temporarily";
				else return "strength is lowered temporarily";
			case STATUS_INTELLIGENCE:
				if(s.strength >= 0) return "intelligence is boosted temporarily";
				else return "intelligence is lowered temporarily";
			case STATUS_CHARISMA:
				if(s.strength >= 0) return "charisma is boosted temporarily";
				else return "charisma is lowered temporarily";
			case STATUS_ENDURANCE:
				if(s.strength >= 0) return "endrance is boosted temporarily";
				else return "endrance is lowered temporarily";
			case STATUS_AGILITY:
				if(s.strength >= 0) return "agility is boosted temporarily";
				else return "agility is lowered temporarily";
			case STATUS_LUCK:
				if(s.strength >= 0) return "luck is boosted temporarily";
				else return "luck is lowered temporarily";
			case STATUS_CRIT:
				if(s.strength >= 0) return "critical rate is boosted temporarily";
				else return "critical rate is lowered temporarily";
			case STATUS_HREGEN:
				if(s.strength >= 0) return "health regeneration is boosted temporarily";
				else return "health regeneration is lowered temporarily";
			case STATUS_MREGEN:
				if(s.strength >= 0) return "mana regeneration is boosted temporarily";
				else return "mana regeneration is lowered temporarily";
			case STATUS_FIRE:
				if(s.strength >= 0) return "fire resistance is boosted temporarily";
				else return "fire resistance is lowered temporarily";
			case STATUS_WATER:
				if(s.strength >= 0) return "water resistance is boosted temporarily";
				else return "water resistance is lowered temporarily";
			case STATUS_AIR:
				if(s.strength >= 0) return "air resistance is boosted temporarily";
				else return "air resistance is lowered temporarily";
			case STATUS_EARTH:
				if(s.strength >= 0) return "earth resistance is boosted temporarily";
				else return "earth resistance is lowered temporarily";
			case STATUS_MAGIC:
				if(s.strength >= 0) return "magic resistance is boosted temporarily";
				else return "magic resistance is lowered temporarily";
			case STATUS_SLASH:
				if(s.strength >= 0) return "slashing weapon resistance is boosted temporarily";
				else return "slashing weapon resistance is lowered temporarily";
			case STATUS_BLUNT:
				if(s.strength >= 0) return "blunt weapon resistance is boosted temporarily";
				else return "blunt weapon resistance is lowered temporarily";
			case STATUS_PIERCE:
				if(s.strength >= 0) return "piercing weapon resistance is boosted temporarily";
				else return "piercing weapon resistance is lowered temporarily";
			case STATUS_DISPELL:
				if(s.strength >= 0) return "bad spell effects stand a chance of being dispelled during the course of this spell";
				else return "helpful spell effects stand a chance of being dispelled during the course of this spell";
			case STATUS_DOOM:
				return "The character has a high chance of dying once the duration on this effect times out";
			case STATUS_REFLECT:
				return "reflects incoming spells in the general direction of the attacker";
			case STATUS_INVIS:
				return "The affected creature is invisible until the effect times out";
			case STATUS_LIGHT:
				return "a bright light shines to guide your way";
			case STATUS_DEATH:
				return "death withdrawal; this has undesirable effects on your stats, albeit temporarily";
			default:
				conoutf("%i", s.type);
				return "^f3oh dear, this effect description doesn't exist, you should see a number echoing at the top of the screen, report it (unless it's your fault :P)";
		}
	}

	const char *geteffecticon(status &s)
	{
		switch(s.type)
		{
			case STATUS_HEALTH:
				if(s.strength >= 0) return "data/hud/rpg/gainhealth";
				else return "data/hud/rpg/losehealth";
			case STATUS_MOVE:
				if(s.strength >= 0) return "data/hud/rpg/gainspeed";
				else return "data/hud/rpg/losespeed";
			case STATUS_STRENGTH:
				if(s.strength >= 0) return "data/hud/rpg/gainstr";
				else return "data/hud/rpg/losestr";
			case STATUS_INTELLIGENCE:
				if(s.strength >= 0) return "data/hud/rpg/gainint";
				else return "data/hud/rpg/loseint";
			case STATUS_CHARISMA:
				if(s.strength >= 0) return "data/hud/rpg/gaincha";
				else return "data/hud/rpg/losecha";
			case STATUS_ENDURANCE:
				if(s.strength >= 0) return "data/hud/rpg/gainend";
				else return "data/hud/rpg/loseend";
			case STATUS_AGILITY:
				if(s.strength >= 0) return "data/hud/rpg/gainagi";
				else return "data/hud/rpg/loseagi";
			case STATUS_LUCK:
				if(s.strength >= 0) return "data/hud/rpg/gainluck";
				else return "data/hud/rpg/loseluck";
			case STATUS_CRIT:
				if(s.strength >= 0) return "data/hud/rpg/upcrit";
				else return "data/hud/rpg/downcrit";
			case STATUS_HREGEN:
				if(s.strength >= 0) return "data/hud/rpg/uphreg";
				else return "data/hud/rpg/downhreg";
			case STATUS_MREGEN:
				if(s.strength >= 0) return "data/hud/rpg/upmreg";
				else return "data/hud/rpg/downmreg";
			case STATUS_FIRE:
				if(s.strength >= 0) return "data/hud/rpg/upfirerst";
				else return "data/hud/rpg/downfirerst";
			case STATUS_WATER:
				if(s.strength >= 0) return "data/hud/rpg/upwaterrst";
				else return "data/hud/rpg/downwaterrst";
			case STATUS_AIR:
				if(s.strength >= 0) return "data/hud/rpg/upairrst";
				else return "data/hud/rpg/downairrst";
			case STATUS_EARTH:
				if(s.strength >= 0) return "data/hud/rpg/upearthrst";
				else return "data/hud/rpg/downearthrst";
			case STATUS_MAGIC:
				if(s.strength >= 0) return "data/hud/rpg/upmagicrst";
				else return "data/hud/rpg/downmagicrst";
			case STATUS_SLASH:
				if(s.strength >= 0) return "data/hud/rpg/upslashrst";
				else return "data/hud/rpg/downslashrst";
			case STATUS_BLUNT:
				if(s.strength >= 0) return "data/hud/rpg/upbluntrst";
				else return "data/hud/rpg/downbluntrst";
			case STATUS_PIERCE:
				if(s.strength >= 0) return "data/hud/rpg/uppiercerst";
				else return "data/hud/rpg/downpiercerst";
			case STATUS_DISPELL:
				if(s.strength >= 0) return "data/hud/rpg/gooddisp";
				else return "data/hud/rpg/baddisp";
			case STATUS_DOOM:
				return "data/hud/rpg/doom";
			case STATUS_REFLECT:
				return "data/hud/rpg/reflect";
			case STATUS_INVIS:
				return "data/hud/rpg/invis";
			case STATUS_LIGHT:
				return "data/hud/rpg/light";
			case STATUS_DEATH:
				return "data/hud/rpg/death";
			default:
				conoutf("unknown effect icon (report me!) %i", s.type);
				return "data/hud/rpg/mystic_base";
		}
	}

	void gameplayhud(int w, int h)
	{
		if(gui::guisopen()) return;
		//optimised for a resolution of 1600x1200 and/or 4:3 resolutions, the witchcraft below is for non 4:3 screens, such as 1440x900 or even 1280x1024
		//it basically moves stuff down/sideways to cater for the extra screen space, effectively placing the hud in the lower centre,
		//and setting two variables, eh and ew, for shifting things into the empty side screen space (widescreen) or the top (demented tall scren);

		glPushMatrix();

		float ratio = (float)h/(float)w, ew = 0, eh = 0; //Extra Width, Extra Height
		//-ew for the very left, and 1600+ew for the very right
		//1200 for the bottom, -eh for the very top
		if(ratio < .7495) //widescreen
		{
			ew = (1200/ratio - 1600)/2.0f; //note, the below translate is meant to move the to the centre of the screen
			glScalef(h/1200.0f, h/1200.0f, 1);
			glTranslatef(ew, 0, 0);
		}
		else if(ratio > .7505) //some strange tall screen
		{
			eh = (1600 * ratio) - 1200;
			glScalef(w/1600.0f, w/1600.0f, 1);
			glTranslatef(0, eh, 0);

		}
		else //4:3! yay!
			glScalef(h/1200.0f, h/1200.0f, 1);

		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

		if(player1->character) //the idiot playing set his character to something other than ENT_CHAR...
		{
			settexture("data/hud/rpg/hbar", 3);

			stats &s = player1->character->attributes;
			rpgchar &ent = *player1->character;

			glColor4f(1, 1, 1, 1);
			quad(40 - ew, 1040, 250, 30);
			quad(40 - ew, 1085, 250, 30);
			quad(40 - ew, 1130, 250, 30);

			glColor4f(1, 0, 0, 1);
			quad(40 - ew, 1040, 250 * ent.health/s.maxhealth, 30);
			glColor4f(0, 0, 1, 1);
			quad(40 - ew, 1085, 250 * ent.mana/s.maxmana, 30);
			glColor4f(.75, .75, 0, 1);
			quad(40-ew, 1130, 200, 30); //experience

			//so they're right handed.... least they're dextrous you sinistrous... you!
			//hint dextrous = right, sinistrous = left :P
			glColor4f(1, 1, 1, 1);
			if(ent.selected[EQUIP_RHAND])
			{
				defformatstring(icon)("data/hud/rpg/%s", ent.selected[EQUIP_RHAND]->icon);
				settexture(icon, 3);
			}
			else
				settexture("data/hud/rpg/empty", 3);
			quad(320, 1030, 150, 150);

			//do a drawicon for currently selected spell
			if(ent.selectedspell)
			{
				defformatstring(icon)("data/hud/rpg/%s", ent.selectedspell->icon);
				settexture(icon, 3);
			}
			else
				settexture("data/hud/rpg/empty", 3);
			quad(500, 1030, 150, 150);

			//only draw 8 effects
			int skipped = 0;
			loopi(player1->effects.length())
			{
				status &s = player1->effects[i];
				if(s.duration < 1000 || s.duration + s.startmillis < lastmillis) {skipped++; continue;}

				float fade = min(1.0f, (s.duration + s.startmillis - lastmillis) / (s.duration * .2f));
				glColor4f(1, 1, 1, fade);
				settexture(geteffecticon(s), 3);
				quad(1440 + ew - 140 * (i - skipped), -eh + 25, 125, 125);

				glPushMatrix();
				glTranslatef(1440 + ew - 140 * (i - skipped), -eh + 175, 0);
				defformatstring(ds)("%i", (s.duration - (lastmillis - s.startmillis)) / 1000);

				int tw = text_width(ds);
				if(tw > 125)
					glScalef(125.0f/tw, 125.0f/tw, 1);
				draw_text(ds, max(0, (125-tw)/2), 0, 255, 255, 255, fade * 255.0f);

				glPopMatrix();

				if(i - skipped >= 7) break;
			}


		}

		//it's allowed the 600 pixels on the bottom right

		if(selected && selected->name)
		{
			string ds;
			if(selected->character && selected->state == CS_ALIVE)
			{
				settexture("data/hud/rpg/hbar", 3);
				glColor4f(1, 1, 1, 1);
				quad(1050+ew, 1123, 500, 60);
				glColor4f(1, 0, 0, 1);
				quad(1050+ew, 1123, 500 * selected->character->health / selected->character->attributes.maxhealth, 60);
			}
			else
			{
				glPushMatrix();

				formatstring(ds)("e to interact... write me");
				int width = text_width(ds);

				if(width > 550)
				{
					float scale = 550.0f/width;
					glTranslatef(1000+ew, 1060 + 64.0f * (1.0f-scale), 0);
					glScalef(scale, scale, 1);
				}
				else
					glTranslatef(1000+ew, 1060, 0);

				int colour = entcolour(selected);
				draw_text(ds, max(0, (550-width)/2), 64, (colour&0xFF0000) >> 16, (colour&0xFF00) >> 8, colour&0xFF);

				glPopMatrix();
			}

			glPushMatrix();

			formatstring(ds)("%s", selected->name);
			int tw = text_width(ds);

			if(tw > 550)
			{
				float scale = 550.0f/tw;
				glTranslatef(1000+ew, 980 + 64.0f * (1.0f-scale), 0);
				glScalef(scale, scale, 1);
			}
			else
				glTranslatef(1000+ew, 980, 0);

			int colour = entcolour(selected);
			draw_text(ds, max(0, (550-tw)/2), 64, (colour&0xFF0000) >> 16, (colour&0xFF00) >> 8, colour&0xFF);
			glPopMatrix();
		}

		glPopMatrix();
	}

	void respawn()
	{
		if(player1->state==CS_DEAD)
		{
			player1->character->firstattack = player1->character->secondattack = false;
			if(lastmillis < player1->character->lastpain) return;
			respawnself(true);
		}
	}

	void doprimaryattack(bool on)
	{
		if((player1->character->firstattack = on)) respawn();
	}
	ICOMMAND(primaryattack, "D", (int *down), { doprimaryattack(*down!=0); });

	void dosecondaryattack(bool on)
	{
		if((player1->character->secondattack = on)) respawn();
	}
	ICOMMAND(secondaryattack, "D", (int *down), { dosecondaryattack(*down!=0); });

	void setwindowcaption()
	{
		defformatstring(capt)("Sandbox RPG %s: %s", version, getclientmap()[0] ? getclientmap() : "[new map]");
		SDL_WM_SetCaption(capt, NULL);
	}

	void startmap(const char *name) // called just after a map load
	{
		lastcreated = player1;
		gui::clearguis();
		loopvrev(rpgobjs)
		{
			if(i) {delete rpgobjs[i]; rpgobjs.remove(i);}
		}
		if(transfer)
			transfer = false;
		else
		{
			player1->reset();
			defformatstring(ds)("spawn_player");
			execute(ds);
		}

		entities::startmap();

		spawnplayer(player1);
		copystring(clientmap, name ? name : "");
		if(identexists("mapstart")) execute("mapstart");
	}

	void updateworld()
	{
		if(!curtime) return;

		physicsframe();
		rpgobj::update();
		checktriggers();

		selected = (rpgent *)intersectclosest(player1->o, worldpos, player1, 32);
	}

	void adddynlights()
	{
		rpgobj::adddynlights();
	}

	void physicstrigger(physent *d, bool local, int floorlevel, int waterlevel, int material)
	{
		if(d->state!=CS_ALIVE||d->type==ENT_INANIMATE) return;
		switch(material)
		{
			case MAT_LAVA:
				if (waterlevel==0) break;
				playsound(S_BURN, d==player1 ? NULL : &d->o);
				loopi(60)
				{
					vec o = d->o;
					o.z -= d->eyeheight *i/60.0f;
					regularflame(PART_FLAME, o, 6, 2, 0x903020, 3, 2.0f);
					regularflame(PART_SMOKE, vec(o.x, o.y, o.z + 8.0f), 6, 2, 0x303020, 1, 4.0f, 100.0f, 2000.0f, -20);
				}
				break;
			case MAT_WATER:
				if (waterlevel==0) break;
				playsound(waterlevel > 0 ? S_SPLASH1 : S_SPLASH2 , d==player1 ? NULL : &d->o);
				particle_splash(PART_WATER, 200, 200, d->o, (watercolor.x<<16) | (watercolor.y<<8) | watercolor.z, 0.5);
				break;
			default:
				if (floorlevel==0) break;
				playsound(floorlevel > 0 ? S_JUMP : S_LAND, local ? NULL : &d->o);
				break;
		}
	}

	void suicide(physent *d)
	{
		((rpgent *)d)->die(lastmillis);

		if(d==player1)
			conoutf("You died"); //replace with an image?
	}
	int numdynents() { return rpgobjs.length(); }
	dynent *iterdynents(int i) { return i >= 0 ? rpgobjs[i] : NULL; }

	bool canjump()
	{
		respawn();
		return player1->state!=CS_DEAD;
	}

	void newmap(int size)
	{
		if(size>=0) emptymap(size, true, NULL);
		copystring(clientmap, "untitled");
	}

	void openworld(const char *name, bool fall = false)
	{
		string tmp;
		formatstring(tmp)("packages/base/%s.ogz", name);
		if(fileexists(tmp, "r")) load_world(name);
		else if(fall) //a fallback
			load_world(DEFAULTMAP);
	}

	bool intersect(dynent *d, const vec &from, const vec &to)   // if lineseg hits entity bounding box
	{
		float dist;
		vec bottom(d->o), top(d->o);
		bottom.z -= d->eyeheight;
		top.z += d->aboveeye;
		return linecylinderintersect(from, to, bottom, top, d->radius, dist);
	}

	dynent *intersectclosest(const vec &from, const vec &to, rpgent *at, float maxdist)
	{
		dynent *best = NULL;
		float bestdist = maxdist;
		loopi(numdynents())
		{
			dynent *o = iterdynents(i);
			if(o==at) continue;
			if(!intersect(o, from, to)) continue;
			float dist = at->o.dist(o->o);
			if(dist<bestdist)
			{
				best = o;
				bestdist = dist;
			}
		}
		return best;
	}

	void changemap(const char *name) { openworld(name, true); }
	void forceedit(const char *name) { openworld(name); }

	bool showenthelpers() {return editmode;}
	bool allowdoublejump() {return false;}
	bool detachcamera() {return player1->state == CS_DEAD;}
	void resetgamestate()
	{

	}

	void updatecamera() {}
	bool ispaused() {return gui::guisopen();} //returns true whenever menus (namely inventory, spells, quests, etc) are open
	void g3d_gamemenus() {gui::render();}

	const char *getmapinfo() {return NULL;}
	void writemapdata(stream *f) {} //do we save rpg declarations per map or not?
	void writegamedata(vector<char> &extras) {}
	void readgamedata (vector<char> &extras) {}

	const char *gameident() { return "rpg"; }
	const char *defaultconfig() { return "data/defaults.cfg"; }
	const char *autoexec() { return "autoexec.cfg"; }
	const char *savedservers() { return "servers.cfg"; }
	const char *loadimage() { return "data/sandbox_rpg_logo"; }
	void loadconfigs() {}
	void texturefailed(char* name, int slot) {}
	void mmodelfailed(const char *name, int idx) {}
	void mapfailed(const char *name) {}
};
