#include "rpggame.h"

namespace gui
{
	void drawcharacter(g3d_gui &g, bool mainpass);
	void drawinventory(g3d_gui &g, bool mainpass);
	void drawspellbook(g3d_gui &g, bool mainpass);
	void draweffects(g3d_gui &g, bool mainpass);

	enum
	{
		TAB_CHARACTER = 0,
		TAB_INVENTORY,
		TAB_SPELLBOOK,
		TAB_EFFECTS,
		TAB_MAX
	};

	struct rpggui : g3d_callback
	{

		int menustart;
		bool open;
		vec menupos;
		int tab, lasttab, lasthover, page, offset[TAB_MAX];
		rpgent *hover, *temp;

		rpggui() : menustart(0), open(false), menupos(vec(0,0,0)), tab(1), lasttab(1), lasthover(0), page(0), hover(NULL), temp(NULL)
		{
			loopi(TAB_MAX) offset[i] = 0;
		}

		void show(bool on)
		{
			if(!on) return;
			menupos = menuinfrontofplayer();
			menustart = starttime();
			open = on;
		}

		void close()
		{
			open = false;
			page = 0;
		}

		void cleantab(int tab)
		{
			switch(tab)
			{
				case TAB_INVENTORY:
					hover = temp = NULL;
					page = 0;
					break;
				case TAB_SPELLBOOK:
					hover = NULL;
					page = 0;
					break;
				default:
					break;
			}
			offset[TAB_CHARACTER] = 0;

		}

		void gui(g3d_gui &g, bool firstpass)
		{
			if(!game::player1->character) return;
			if(lasttab != tab) cleantab(tab -1);
			lasttab = tab;
			g.start(menustart, 0.05f, &tab);
			switch(tab - 1)
			{
				case TAB_CHARACTER:
					g.tab("Character", 0xFF7F00);

					drawcharacter(g, !firstpass);

					g.tab("Inventory", 0xFF7F00);
					g.tab("Spell Book", 0xFF7F00);
					g.tab("Effects", 0xFF7F00);
					break;
				case TAB_INVENTORY:
				{
					g.tab("Character", 0xFF7F00);
					g.tab("Inventory", 0xFF7F00);

					drawinventory(g, !firstpass);

					g.tab("Spell Book", 0xFF7F00);
					g.tab("Effects", 0xFF7F00);
				}
					break;
				case TAB_SPELLBOOK:
				{
					g.tab("Character", 0xFF7F00);
					g.tab("Inventory", 0xFF7F00);
					g.tab("Spell Book", 0xFF7F00);

					drawspellbook(g, !firstpass);

					g.tab("Effects", 0xFF7F00);
					break;
				}
				case TAB_EFFECTS:
				{
					g.tab("Character", 0xFF7F00);
					g.tab("Inventory", 0xFF7F00);
					g.tab("Spell Book", 0xFF7F00);
					g.tab("Effects", 0xFF7F00);

					draweffects(g, !firstpass);

					break;
				}
				default:
				{
					defformatstring(ds)("1) scream and panic\n2) note the number %i\n3) File a bug report for the gui no. %i\n4) ???\n5) profit!!! You can probably resume normal use by reopening this menu.", tab-1, tab-1);
					g.textbox(ds, 71, 24, 0xFF0000);

					break;
				}
			}
			g.end();
		}

		void render()
		{
			if(open) g3d_addgui(this, menupos, GUI_FORCE_2D|GUI_FOLLOW);
		}
	};

	rpggui playergui = rpggui();

	//FIXME: make sizes between guis consistent; note that image width is 4* scale for width with the default font instead of 2 * scale as it is for height

	void drawcharacter(g3d_gui &g, bool mainpass)
	{
		stats &base = game::player1->character->base, &attributes = game::player1->character->attributes;
		rpgchar &ent = *game::player1->character;

		g.pushlist();
		g.pushlist();


		defformatstring(ds)("Health: \t\t%.0f/%i (%i)\nHealth Regen: \t%g (%g)\nMana: \t\t%.0f/%i (%i)\nMana Regen: \t%g (%g)\nMovespeed: \t%i (%i)\nJump Height: \t%i (%i)\nMax Weight: \t%i/%i (%i)",
			ent.health, attributes.maxhealth, base.maxhealth,
			attributes.healthregen, base.healthregen,
			ent.mana, attributes.maxmana, base.maxmana,
			attributes.manaregen, base.manaregen,
			attributes.movespeed, base.movespeed,
			attributes.jumpvel, base.jumpvel,
			0, attributes.maxweight, base.maxweight
		);
		g.textbox(ds, 27, 8, 0xFFAF00);
		g.separator();

		g.pushlist();
		formatstring(ds)("Strength:\t\t%i (%i)\nIntelligence: \t%i (%i)\nCharisma:\t\t%i (%i)\nEndurance: \t%i (%i)\nAgility:\t\t%i (%i)\nLuck:\t\t\t%i (%i)",
			attributes.strength, base.strength,
			attributes.intelligence, base.intelligence,
			attributes.charisma, base.charisma,
			attributes.endurance, base.endurance,
			attributes.agility, base.agility,
			attributes.luck, base.luck
		);

		g.textbox(ds, 24, 6, 0xFFAF00);

		g.pushlist();
		//TODO stat point distribution
		g.button("", 0, "add");
		g.button("", 0, "add");
		g.button("", 0, "add");
		g.button("", 0, "add");
		g.button("", 0, "add");
		g.button("", 0, "add");

		g.poplist();
		g.poplist();

		g.separator();

		//TODO next level calculation
		formatstring(ds)("Level: \t\t%i\nExperience:\t%i (%i)\nStat Points: \t%i",
			ent.level,
			ent.experience, -1,
			ent.statpoints
		);
		g.textbox(ds, 27, 8, 0xFFAF00);

		g.poplist();
		g.space(2);


		#define resist(n) attributes.resistance[n], base.resistance[n]
		formatstring(ds)("\tResistances\nFire: \t%i (%i)\nEarth: \t%i (%i)\nAir: \t\t%i (%i)\nWater: \t%i (%i)\nSlash: \t%i (%i)\nPierce: \t%i (%i)\nBlunt: \t%i (%i)\nMagic: \t%i (%i)\n",
			resist(RESIST_FIRE),
			resist(RESIST_EARTH),
			resist(RESIST_AIR),
			resist(RESIST_WATER),
			resist(RESIST_SLASH),
			resist(RESIST_PIERCE),
			resist(RESIST_BLUNT),
			resist(RESIST_MAGIC)
		);
		#undef resist

		g.textbox(ds, 20, 9, 0xFFAF00);

		g.space(2);

		#define skill(n) attributes.skills[n].level, base.skills[n].level

		formatstring(ds)("\t\tSkills\nBlade: \t\t%i (%i)\nMarksman: \t%i (%i)\nUnarmed: \t\t%i (%i)\nGun: \t\t%i (%i)\nRepair: \t\t%i (%i)\nThrow: \t\t%i (%i)\nHeal: \t\t%i (%i)\nMagic: \t\t%i (%i)\nBarter: \t\t%i (%i)\nSneak: \t\t%i (%i)",
			skill(SKILL_BLADE),
			skill(SKILL_MARKSMAN),
			skill(SKILL_UNARMED),
			skill(SKILL_GUN),
			skill(SKILL_REPAIR),
			skill(SKILL_THROW),
			skill(SKILL_HEAL),
			skill(SKILL_MAGIC),
			skill(SKILL_BARTER),
			skill(SKILL_SNEAK)
		);

		g.textbox(ds, 20, 11, 0xFFAF00);

		#undef skill
		g.poplist();
	}

	void cullstring(string &s, int len)
	{
		int width = len * 32, tw = text_width(s);
		if(width - 48 > tw) return;
		int start = strlen(s) + 3;

		do
		{
			//go for bigger steps at first
			start -= max(1, (tw-width) / 64);
			s[start] = '\0';
			s[start-1] = s[start-2] = s[start-3] = '.';
			tw = text_width(s);
		}
		while(tw > width);
	}

	//use a width of 25 and a height of 10
	void draweffects(g3d_gui &g, bool mainpass, rpgent *item, int &offset, int width = 25, int height = 5)
	{
		if(!item) {g.textbox("No effects", width, height, 0xFFAF3F); return;}
		offset = max(0, min(offset, item->effects.length() - height));
		g.pushlist();


		g.pushlist();

		loopi(height)
		{
			int index = i + offset;
			if(item->effects.inrange(index))
			{
				status &s = item->effects[index];
				g.pushlist();

				//this creates the string and makes sure it fits within the alloted space
				string ds;
				defformatstring(desc)("%s", game::geteffectdescription(s));
				cullstring(desc, width-6);
				formatstring(ds)("%s\n", desc);
				formatstring(desc)("strength: %i duration %i", abs(s.strength), s.duration/1000);
				cullstring(desc, width-6);
				concatstring(ds, desc);

				Texture *icon = textureload(game::geteffecticon(s), 3, false, false);
				g.image(icon, 1);
				g.textbox(ds, width-6, 2, 0xFFAF3F);

				g.poplist();
			}
			else
				g.textbox("", width-2, 2, 0);
		}

		g.poplist();
		g.slider(offset, 0, max(0, item->effects.length() - height), 0xFFAF3F, NULL, true);

		g.poplist();

	}

	//71x24
	void drawinventory(g3d_gui &g, bool mainpass)
	{
		enum
		{
			PAGE_INVEN = 0,
			PAGE_USE
		};
		//Items are displayed in a 5x6 grid
		rpgchar &ent = *game::player1->character;
		int &offset = playergui.offset[TAB_INVENTORY], &lasthover = playergui.lasthover,
			&page = playergui.page;

		switch(page)
		{
			case PAGE_INVEN:
			{
				g.pushlist();
				g.pushlist();
				Texture *empty = textureload("data/hud/rpg/empty", 3, false, false),
					*icon = NULL;
				offset = max(0, min(offset, (ent.inventory.length()-26) / 5));

				if(ent.inventory.inrange(lasthover))
				{
					rpgent *tmp = ent.inventory[lasthover];
					defformatstring(ds)("%s", tmp->name);
					cullstring(ds, 28);
					g.title(ds, 0xFFAF00);
					g.textbox(tmp->description, 28, 8, 0xFFAF7F);
					g.textbox("This textbox will eventually contain a brief summary of whatever the item will do to you", 28, 13, 0x2FAFFF);
				}
				else
					g.textbox("", 28, 22, 0);

				g.poplist();

				//now FINALLY draw the grid

				loopi(5)
				{
					g.pushlist();
					loopj(6)
					{
						int index = (offset + j) * 5 + i;
						if(ent.inventory.inrange(index))
						{
							rpgent *tmp = ent.inventory[index];
							defformatstring(ds)("data/hud/rpg/%s", tmp->icon);
							icon = textureload(ds, 3, false, false);
							int test = g.image(icon, 2);
							if(test&G3D_ROLLOVER) lasthover = index;
							if(test&G3D_UP) {playergui.hover = tmp; page = PAGE_USE;}
						}
						else
							if(g.image(empty, 2)&G3D_ROLLOVER) lasthover = index;
					}
					g.poplist();
				}
				g.space(1);
				g.slider(offset, 0, max(0, (ent.inventory.length()-26) / 5), 0xFF7F2F, NULL, true);
				g.poplist();

				break;
			}
			case PAGE_USE:
			{
				defformatstring(ds)("%s", playergui.temp ? playergui.temp->name : "");
				cullstring(ds, 71);
				g.title(ds, 0x3F8FFF);
				g.pushlist();
				g.pushlist();

				formatstring(ds)("data/hud/rpg/%s", playergui.temp ? playergui.temp->icon : "empty");
				Texture *icon = textureload(ds, 3, false, false);
				g.image(icon, 4);

				bool check = false;
				const char *slots[] = {"Left", "Right", "Feet", "Legs", "Torso", "Misc", "Misc-2"};
				const char *icons[] = {"lhand", "rhand", "feet", "legs", "torso", "misc", "misc"};
				int count = 0;
				loopi(EQUIP_MAX)
				{
					if(playergui.hover == game::player1->character->selected[i])
					{
						count ++;
						formatstring(ds)("unequip (%s)", slots[i]);
						int test = g.button(ds, 0xFFAA00, icons[i]);
						if(test&G3D_UP) game::player1->dequip(playergui.hover);
						if(test&G3D_ROLLOVER && mainpass) {playergui.temp = game::player1->character->selected[i]; check = true;}
					}
					else if(playergui.hover->item->slots & (1<<i))
					{
						count ++;
						formatstring(ds)("equip (%s)", slots[i]);
						int test = g.button(ds, 0xFFDD00, icons[i]);
						if(test&G3D_UP) game::player1->equip(playergui.hover, i);
						if(test&G3D_ROLLOVER && mainpass) {playergui.temp = game::player1->character->selected[i]; check = true;}
					}
				}

				g.space(12-count);
				if(g.button("drop", 0xFF3F8F, "drop")&G3D_UP) rpgobj::dropitem(playergui.hover, game::player1);
				g.space(1);
				if(g.button("back", 0xFF3F8F, "exit")&G3D_UP) page = PAGE_INVEN;

				g.poplist();
				g.space(1);
				g.pushlist();
				g.pushlist();

				g.textbox(playergui.temp ? playergui.temp->description : "", 26 , 12, 0xFFAF3F);
				g.separator();
				g.textbox("describe requirements of item here", 26 , 12, 0xAF00FF);

				g.poplist();
				g.separator();
				draweffects(g, mainpass, playergui.temp, playergui.offset[TAB_CHARACTER], 54, 5);

				g.poplist();
				g.poplist();
				if(!check && mainpass) {playergui.temp = playergui.hover;};
				break;
			}
			default:
			{
				defformatstring(ds)("My isn't this embarassing, you better tell someone this page (%d) of menu (%d) doesn't exist.\nDon't forget to tell us how you got here either.", page, TAB_INVENTORY);
				g.textbox(ds, 71, 24, 0xFF0000);
				break;
			}
		}


	}

	void drawspellbook(g3d_gui &g, bool mainpass)
	{
		rpgchar &ent = *game::player1->character;
		int &offset = playergui.offset[TAB_SPELLBOOK], &page = playergui.page;
		int length = ent.spellbook.length();
		offset = max(0, min(offset, (length-9) / 2));


		enum
		{
			PAGE_SPELLS = 0,
			PAGE_USE
		};

		switch(page)
		{
			case PAGE_SPELLS:
			{
				g.pushlist();
				g.pushlist();

				loopi(5)
				{
					if(i) g.space(1);
					g.pushlist();
					loopj(2)
					{
						int s = (offset + i) * 2 + j;
						rpgent *spell = NULL;
						if(ent.spellbook.inrange(s))
							spell = ent.spellbook[s];

						defformatstring(ds)("data/hud/rpg/%s", spell ? spell->icon : "empty");
						Texture *icon = textureload(ds, 3, false, false);
						if(g.image(icon, 2)&G3D_UP && spell)
						{
							playergui.hover = spell;
							page = PAGE_USE;
						}

						defformatstring(newdesc)("%s", spell ? spell->description : "empty");

						cullstring(newdesc, 52);

						formatstring(ds)("\fs\fD%s\fr\n%s\nmanacost: %i effects: %i",
							spell ? spell->name : "empty",
							newdesc,
							spell ? spell->spell->cost : 0,
							spell ? spell->effects.length() : 0
						);
						g.textbox(ds, 26, 4, 0xFFAF00);
						if(!j) g.space(1);
					}
					g.poplist();
				}

				g.poplist();
				g.slider(offset, 0, max(0, (length-7)/2), 0xFF7F3F, NULL, true);
				g.poplist();
				break;
			}
			case PAGE_USE:
			{
				defformatstring(ds)("%s", playergui.hover->name);
				cullstring(ds, 71);
				g.title(ds, 0x3F8FFF);
				g.pushlist();
				g.pushlist();

				formatstring(ds)("data/hud/rpg/%s", playergui.hover->icon);
				Texture *icon = textureload(ds, 3, false, false);
				int test = g.image(icon, 4);
				test |= g.button("equip", 0xFFAF00, "lhand");

				if(test&G3D_UP) {game::player1->equip(playergui.hover);}
				g.space(13);
				if(g.button("back", 0xFFAF00, "exit")&G3D_UP) {page = 0;}

				g.poplist();
				g.space(1);
				g.pushlist();
				g.pushlist();

				g.textbox(playergui.hover->description, 26 , 12, 0xFFAF3F);
				g.separator();
				g.textbox("write me (requirements and effects)", 26, 12, 0xFFAF3F);

				g.poplist();

				g.separator();
				draweffects(g, mainpass, playergui.hover, playergui.offset[TAB_CHARACTER], 54, 5);

				g.poplist();
				g.poplist();
				break;
			}
			default:
			{
				defformatstring(ds)("dude! this page like don't exist bro, you should like report it and stuff (report me: spellbook tab page %i)", page);
				g.textbox(ds, 71, 24, 0xFFFF00);
			}
		}
	}

	void draweffects(g3d_gui &g, bool mainpass)
	{
		rpgent &ent = *game::player1;
		int &offset = playergui.offset[TAB_EFFECTS];
		int length = ent.effects.length();
		//1x8
		offset = max(0, min(offset, length - 8));
		g.pushlist();
		g.pushlist();

		int skipped = 0;

		loopi(8+skipped)
		{
			int index = offset+i;
			status *s = NULL;
			if(ent.effects.inrange(index))
				s = &ent.effects[index];
			if(s && s->duration < 1000) {skipped++; continue;}
			Texture *icon = textureload( s? game::geteffecticon(*s) : "data/hud/rpg/mystic_base", 3, false, false);

			g.image(icon, 1.5);
		}

		g.poplist();
		g.space(1);
		g.pushlist();

		skipped = 0;
		loopi(8+skipped)
		{
			int index = offset+i;
			status *s = NULL;
			if(ent.effects.inrange(index))
				s = &ent.effects[index];
			if(s && s->duration < 1000) {skipped++; continue;}
			if(!s) g.textbox("", 60, 3, 0);
			else
			{
				defformatstring(ds)("%s\nDuration: %i  Strength: %i", game::geteffectdescription(*s), (s->startmillis + s->duration - lastmillis)/1000, s->strength);
				g.textbox(ds, 60, 3, 0xFF7F00);
			}
		}

		g.poplist();

		g.space(2);
		g.slider(offset, 0, length-8, 0xFF7F00, NULL, true);
		g.poplist();
	}

	//71x24

	void renderchat(g3d_gui &g, bool firstpass);


	struct rpgchatgui : g3d_callback
	{
		int offset[3], page;
		bool showing;
		vec menupos;

		/* struct trade
		{
			bool player; //as in, it's the player's
			int id; //index
			int value;
		};
		vector<trade> swaps; */

		rpgchatgui() : page(0), showing(false), menupos(vec(0,0,0))
		{
			loopi(3) offset[i] = 0;
		}
		~rpgchatgui() {}

		enum
		{
			PAGE_TALK = 0,
			PAGE_TRADE = 1,
			PAGE_REWARD = 2,

			TAB_BUY = 0,
			TAB_SELL = 1
		};

		void render()
		{
			if(!showing && showing != (game::selected && game::selected->chatpos >= 0))
				menupos = menuinfrontofplayer();
			showing = (game::selected && game::selected->chatpos >= 0);

			if(game::selected && game::selected->chatpos >= 0) g3d_addgui(this, menupos, GUI_FORCE_2D|GUI_FOLLOW);
		}

		void close()
		{
			if(game::selected) game::selected->chatpos = -1;
			page = 0;
			loopi(3) offset[i] = 0;
		}

		void gui(g3d_gui &g, bool firstpass)
		{
			if(!game::player1->character || !game::selected) return;
			g.start(0, 0.05f);
			switch(page)
			{
				case PAGE_TALK:
					renderchat(g, !firstpass);
					break;
				case PAGE_TRADE:
					break;
				case PAGE_REWARD:
					break;
			}
			g.end();
		}
	} chatgui;

	void renderchat(g3d_gui &g, bool firstpass)
	{
		rpgent *npc = game::selected;
		int &offset = chatgui.offset[1];

		if(npc->dialogue.inrange(npc->chatpos))
		{
			g.textbox(npc->dialogue[npc->chatpos]->talk, 71, 10, 0xFF7F00);

			//reset dialogue options, and regenerate the listings, it should be attempted that this be done once per transition instead of per frame
			npc->dialogue[npc->chatpos]->dests.deletecontentsp();
			if(npc->dialogue[npc->chatpos]->script)
				execute(npc->dialogue[npc->chatpos]->script);

			g.separator();
			g.pushlist();
			g.slider(offset, 0, max(0, npc->dialogue[npc->chatpos]->dests.length()), 0x7FFF00, NULL, true);
			g.pushlist();

			offset = max(0, min(offset, npc->dialogue[npc->chatpos]->dests.length() - 5));
			int newchatpos = npc->chatpos;
			loopi(5)
			{
				int index = i + offset;
				if(npc->dialogue[npc->chatpos]->dests.inrange(index))
				{
					response &d = *npc->dialogue[npc->chatpos]->dests[index];
					defformatstring(ds)("%s", d.talk);
					cullstring(ds, 69);

					if(g.button(ds, 0xBFBF00, NULL)&G3D_UP)
					{
						if(d.script)
							execute(d.script);
						if(d.dest < 0 || npc->dialogue.inrange(d.dest)) //keep in mind, -ve's mean close
							newchatpos = d.dest;
					}
				}
				else
					g.text("", 0);
			}

			g.poplist();
			g.poplist();
			npc->chatpos = newchatpos;
		}
		else
		{
			conoutf("This NPC lacks this dialogue options, please fix it up %i; exiting GUI", npc->chatpos);
			chatgui.close();
		}
	}

	void clearguis()
	{
		playergui.close();
		chatgui.close();
	}

	VARF(showplayergui, 0, 0, 1, showplayergui ? playergui.show(true) : playergui.close());

	bool guisopen()
	{
		return (playergui.open || (game::selected && game::selected->chatpos >= 0));
	}

	void render()
	{
		playergui.render();
		chatgui.render();
	}
};
