#include "rpggame.h"

namespace rpgobj
{
	struct dynlightcache
	{
		vec o, initcol, col;
		int flags, initrad, rad, fade, peak;


		dynlightcache(const vec &_o, float _rad, const vec &_col, int _fade = 0, int _peak = 0, int _flags = 0, float _initrad = 0, const vec &_initcol = vec(0,0,0)) :
		o(_o), initcol(_initcol), col(_col), flags(_flags), initrad(_initrad), rad(_rad), fade(_fade), peak(_peak)
		{}
		~dynlightcache() {};
	};
	vector <dynlightcache> lights;
	vector<projeffect *> effects;

	VARFP(rpgobjupdatedist, 64, 512, 4096,
		if(game::rpgobjdist > rpgobjupdatedist)
			game::rpgobjdist = rpgobjupdatedist;
	);

	void dropitem(rpgent *item, rpgent *parent)
	{
		bool removed;
		loopv(parent->character->inventory)
		{
			if(item == parent->character->inventory[i])
			{
				parent->character->inventory.remove(i);
				removed = true;
				break;
			}
		}
		if(!removed)
		{
			loopv(parent->character->spellbook)
			{
				if(item == parent->character->spellbook[i])
				{
					parent->character->spellbook.remove(i);
					removed = true;
					break;
				}
			}
		}
		loopi(EQUIP_MAX)
		{
			if(parent->character->selected[i] == item)
			{
				parent->character->selected[i] = NULL;
			}
		}
		if(removed)
		{
			game::rpgobjs.add(item);
			vec pos; vecfromyawpitch(parent->yaw, 0, 1, 0, pos); pos.mul(10);
			item->o = parent->o; item->o.add(pos); item->newpos = item->o;
			item->yaw = parent->yaw;
			if(item->etype == ENT_CHAR) {item->respawn();}
			return;
		}
	}

	void worlduse(rpgent *d, rpgent *s)
	{
		if(!d || !s) return;
		if(s->etype == ENT_CHAR && s->state==CS_DEAD)
		{
			conoutf("entity is dead, open loot screen");
			return;
		}
		if(s->interact)
		{
			defformatstring(ds)("%i", getident(d));
			alias("rpgactor", ds);

			formatstring(ds)("%i", getident(s));
			alias("rpgselected", ds);

			execute(game::selected->interact);
			return;
		}
	}

	void pickup(rpgent *d, rpgent *o)
	{
		if(!d || !o) return;
		if(o->etype==ENT_ITEM)
		{
			d->character->inventory.add(o);
			d->character->updatestats = true;
		}
		else if (o->etype == ENT_SPELL)
			d->character->spellbook.add(o);
		else
			return;

		loopv(game::rpgobjs)
		{
			if(game::rpgobjs[i] == o)
			{
				game::rpgobjs.remove(i);
				return;
			}
		}
	}
	ICOMMAND(worlduse, "", (), worlduse(game::player1, game::selected));

	void updateeffects(rpgent *d, stats &stat)
	{
		loopv(d->effects)
		{
			status &s = d->effects[i];
			if ((s.duration + s.startmillis + 200 < lastmillis ) ||
				(s.applied == s.strength && (s.duration + s.startmillis) < lastmillis))  {d->effects.remove(i); i--; continue;}

			//spells/effects/enchantments fade linearly over the last 20% of their lifespan
			float potency = 1.0f;
			if((s.duration + s.startmillis - lastmillis) < (s.duration * .2f))
				potency = (s.duration + s.startmillis - lastmillis) / (s.duration * .2f);

			stats &attr = d->character->attributes;

			switch(s.type)
			{
				case STATUS_HEALTH:
				{
					if((lastmillis - s.startmillis) * s.strength / s.duration == s.applied) continue;
					float delta = 0;

					if(s.strength < 0)
						delta = max(s.strength - s.applied, ((lastmillis - s.startmillis) * s.strength / s.duration) - s.applied);
					else
						delta = min(s.strength - s.applied, ((lastmillis - s.startmillis) * s.strength / s.duration) - s.applied);

					if(delta < 0) d->takedamage(-delta, s.resists);
					else d->character->health += delta;
					s.applied += delta;
					break;
				}
				case STATUS_MOVE:
					s.applied = s.strength;
					stat.movespeed += s.strength * potency;
					stat.jumpvel += s.strength * potency;
					break;
				case STATUS_STRENGTH:
					s.applied = s.strength;
					attr.strength += s.strength * potency;
					break;
				case STATUS_INTELLIGENCE:
					s.applied = s.strength;
					attr.intelligence += s.strength * potency;
					break;
				case STATUS_CHARISMA:
					s.applied = s.strength;
					attr.charisma += s.strength * potency;
					break;
				case STATUS_ENDURANCE:
					s.applied = s.strength;
					attr.endurance += s.strength * potency;
					break;
				case STATUS_AGILITY:
					s.applied = s.strength;
					attr.agility += s.strength * potency;
					break;
				case STATUS_LUCK:
					s.applied = s.strength;
					attr.luck += s.strength * potency;
					break;
				case STATUS_CRIT:
					s.applied = s.strength;
					conoutf("unimplemented");
					break;
				case STATUS_HREGEN:
					s.applied = s.strength;
					stat.healthregen += s.strength * potency;
					break;
				case STATUS_MREGEN:
					s.applied = s.strength;
					stat.manaregen += s.strength * potency;
					break;
				case STATUS_FIRE:
				case STATUS_WATER:
				case STATUS_AIR:
				case STATUS_EARTH:
				case STATUS_MAGIC:
				case STATUS_SLASH:
				case STATUS_BLUNT:
				case STATUS_PIERCE:
					s.applied = s.strength;
					stat.resistance[s.type - STATUS_FIRE] += s.strength * potency;
					break;
				case STATUS_DISPELL:
				case STATUS_DOOM:
				case STATUS_REFLECT:
					conoutf("unimplemented");
				case STATUS_INVIS:
					s.applied = s.strength;
					d->temp.fade -= (s.strength * potency) / 100.0f;
					break;
				case STATUS_LIGHT:
					s.applied = s.strength;
					lights.add(dynlightcache(d->abovehead(), s.strength * 2 * potency, vec(.6, .5, .3), 1)); //TODO make light colours configurable
					break;
				case STATUS_DEATH:
				{
					stats st = d->character->base;
					st.mul(.8f * potency);
					d->character->attributes.sub(st);
					break;
				}
			}
		}
	}

	void adddynlights()
	{
		//the colour vec must have a magnitude above 64 (or else it's too dark to make an impression)
		//the radius must be greater than 32,or else it's too small to really see
		//exceptions are allowed, they just put greater burdens (and we're limited to 5 dynlights)
		//adddynlight(const vec &o, float radius, const vec &color, int fade = 0, int peak = 0, int flags = 0, float initradius = 0, const vec &initcolor = vec(0, 0, 0), physent *owner = NULL);
		loopv(game::rpgobjs)
		{
			rpgent *d = game::rpgobjs[i];
			if(!d->character) continue;
			loopvj(d->character->projs)
			{
				projectile *p = d->character->projs[j];
				if(!effects.inrange(p->effect)) continue;
				projeffect *sfx = effects[p->effect];
				if(!sfx->dynlight || sfx->lightradius < 32) continue;
				vec colour = vec((sfx->lightcolour >> 16) &0xFF, (sfx->lightcolour >> 8) &0xFF, sfx->lightcolour&0xFF);
				if(colour.magnitude() < 64) continue;
				//before adding the light, scale it down by 256 first, wouldn't want to hurt our eyes
				if(sfx->lightcolour < 0) colour.div(-256.0f);
				else colour.div(256.0f);
				//now that the tests have passed... ADD THE BLOODY LIGHT
				adddynlight(p->o, sfx->lightradius, colour);
			}
		}
		loopv(lights)
		{
			dynlightcache &l = lights[i];
			adddynlight(l.o, l.rad, l.col, l.fade, l.peak, l.flags, l.initrad, l.initcol);
		}
		lights.setsizenodelete(0);
	}

	void applyeffects(rpgent *victim, rpgent *weapon, rpgent *attacker)
	{
		if(!victim || victim->etype != ENT_CHAR || victim->state != CS_ALIVE|| !weapon || !attacker || !attacker->character) return;
		float multiplier = attacker->geteffectmul(*weapon);

		loopv(weapon->effects)
		{
			status &s = weapon->effects[i];
			victim->effects.add(status(s.type, s.strength * multiplier, s.duration * multiplier, s.resists));
		}
	}

	void playdeatheffect(vec o, projeffect *sfx, int radius, vec dir = vec(0, 0, 1), rpgent *wep = NULL)
	{
		bool limit = false;
		if(wep->spell && wep->spell->type == STYPE_CONE) limit = true;

		switch(sfx->deathpart)
		{
			case PART_EXPLOSION:
			case PART_EXPLOSION_NO_GLARE:
				particle_fireball(o, radius, sfx->deathpart, sfx->deathfade, sfx->deathpartcol, 0);
				break;
			case PART_STREAK:
			case PART_LIGHTNING:
			{
				loopi(limit ? 2 : 75)
				{
					float yaw = rnd(360), pitch = rnd(180) - 90;
					vec d;
					vecfromyawpitch(yaw, pitch, 1, 0, d);
					d.mul(radius); d.add(o);
					particle_flare(o, d, sfx->deathfade, sfx->deathpart, sfx->deathpartcol, sfx->deathpartsize);
				}
				break;
			}
			default:
				particle_splash(sfx->deathpart, limit ? 3 : 150, sfx->deathfade, o, sfx->deathpartcol, sfx->deathpartsize, radius, sfx->gravity ? sfx->gravity : 200);
				break;
		}

		if(sfx->deathdecal >= 0) adddecal(
			sfx->deathdecal,
			o,
			dir.neg(),
			radius,
			bvec(
				(sfx->deathpartcol<<16)&0xFF,
				(sfx->deathpartcol<<8)&0xFF,
				(sfx->deathpartcol&0xFF)
			)
		);

		if(sfx->dynlight && sfx->lightradius >= 32)
		{
			vec colour = vec((sfx->lightcolour >> 16) &0xFF, (sfx->lightcolour >> 8) &0xFF, sfx->lightcolour&0xFF);
			if(colour.magnitude() >= 64)
			{
				if(sfx->lightcolour < 0) colour.div(-256.0f); //shadow light
				else colour.div(256.0f);

				vec initcolour = vec((sfx->deathlightinitcol >> 16) &0xFF, (sfx->deathlightinitcol >> 8) &0xFF, sfx->deathlightinitcol&0xFF);
				if(sfx->deathlightinitcol < 0) initcolour.div(-256.0f);
				else initcolour.div(256.0f);

				lights.add(dynlightcache(o, sfx->lightradius * 2, initcolour, sfx->deathlightfade, sfx->deathlightfade/2, sfx->deathlightflags, sfx->lightradius, colour));
			}
		}
	}

	void updateprojs(rpgent *d)
	{
		loopv(d->character->projs)
		{
			projectile &p = *d->character->projs[i];
			vec a = p.d;
			a.mul((p.speed*curtime)/1000.0f); //the delta
			vec pos;
			rpgent *victim = NULL;

			projeffect *sfx =  NULL;
			if(effects.inrange(p.effect))
				sfx = effects[p.effect];

			bool hit = false;
			if(raycubepos(p.o, p.d, pos, 0, RAY_CLIPMAT|RAY_ALPHAPOLY) <= a.magnitude()) //note, p.a becomes the new destination vector, the distance travelled is returned
			{
				hit = true;
				p.o = pos;
			}
			else
			{
				victim = (rpgent *)game::intersectclosest(p.o, vec(p.o).add(a), d);
				if(victim)
				{
					hit = true;
					p.o.add(vec(p.d).mul(victim->o.dist(p.o) - victim->radius * 1.5));
				}
			}
			if(hit)
			{
				loopvj(game::rpgobjs)
				{
					rpgent *v = game::rpgobjs[j];

					float dist = v->o.dist(p.o);
					if(dist < p.radius || v == victim)
					{
						rpgent *v = game::rpgobjs[j];
						if(v->etype == ENT_CHAR) applyeffects(v, &p.weapon, d);

						//kickback
						vec delta = vec(v->o).sub(p.o); delta.normalize();
						delta.mul(sfx->kickback * p.radius/(dist + .001f));
						v->vel.add(delta);

						//FIXME am I doing this right?
						if(v->ragdoll) ragdolladdvel(v, delta);
					}
				}
				if(sfx)
				{
					playdeatheffect(p.o, sfx, p.radius, p.d, &p.weapon);
				}
				d->character->projs.remove(i); i--; continue;
			}
			if(p.gravity)
			{
				p.d.z += (-p.gravity * curtime) / (1000.0f * p.speed);
			}
			p.o.add(a);
		}
	}

	void updateinv(rpgent *d, stats &s) //apply on item equip only
	{
		loopv(d->character->inventory)
		{
			rpgent *r = d->character->inventory[i];
			if(r->etype == ENT_CHAR || r->etype == ENT_OBJECT) {dropitem(r, d); continue;}
			else if(r->etype==ENT_SPELL)
			{
				d->character->inventory.remove(i--);
				loopvj(d->character->spellbook) {if (r == d->character->spellbook[j]) {continue;}}
				d->character->spellbook.add(r);
				continue;
			}
			d->character->attributes.add(r->item->invbonus);
			s.addall(r->item->invbonus).sub(r->item->invbonus); //only add relevant bits
		}

		//just to make sure no non-spells end in the spellbook
		loopv(d->character->spellbook)
		{
			rpgent *r = d->character->spellbook[i];
			if(r->etype == ENT_CHAR || r->etype == ENT_OBJECT)
				dropitem(r, d);
			else if(r->etype==ENT_ITEM)
			{
				d->character->spellbook.remove(i--);
				loopvj(d->character->inventory) {if (r == d->character->inventory[j]) {continue;}}
				d->character->inventory.add(r);
			}
		}

		loopi(EQUIP_MAX)
		{
			rpgent *r = d->character->selected[i];
			if(!r) continue;
			d->character->attributes.add(r->item->equipbonus);
			s.addall(r->item->invbonus).sub(r->item->invbonus);
		}
	}



	/*void doattack(rpgent *d, rpgent *item);
	{
		if(!item)

	}*/

	void addspellprojectile(rpgent *d, rpgent *s, bool fuzzy = false)
	{
		if(!d || !s) return;
		if(!effects.inrange(s->spell->effect)) return;

		projeffect *sfx = effects[s->spell->effect];
		float maxyawdelta = fuzzy ? 30 : (10 * (100 - d->character->attributes.skills[SKILL_MAGIC].level) / 100.0f);
		float maxpitchdelta = fuzzy ? 5 : (2 * (100 - d->character->attributes.skills[SKILL_MAGIC].level) / 100.0f);

		projectile *p = d->character->projs.add(new projectile(*s));
		vecfromyawpitch(d->yaw + maxyawdelta * (rnd(201) - 100) / 100, d->pitch+ maxpitchdelta * (rnd(201) - 100) / 100, 1, 0, p->d);
		p->o = vec(p->d).mul(d->radius);
		p->o.add(d->o);

		p->d.add(vec(d->vel).div(sfx->basevel));
		p->effect = s->spell->effect;
		p->radius = s->spell->range;
		p->gravity = s->spell->gravity;

		p->speed = sfx->basevel;
		p->speed += (rnd(201) - 100) / 100.0f * 0.2f * sfx->basevel;
	}

	void attack(rpgent *d)
	{
		if(d->character->firstattack)
		{
			//who said they're not allowed to be ambi dextrous? :D
			rpgent *rhand = d->character->selected[EQUIP_RHAND],
				*lhand = d->character->selected[EQUIP_LHAND];
			if(rhand && lhand)
			{
				//TODO, prevent this case
				if(rhand->item->type == ITYPE_RANGED)rhand = NULL; //bows require two hands
				if(lhand->item->type == ITYPE_RANGED)lhand = NULL;
				conoutf("warning: bow and melee equipped, bows need two hands");
			}

		}
		else if(d->character->secondattack)
		{
			//TODO cast delay
			if(!d->character->selectedspell) return;
			rpgent *s = d->character->selectedspell;
			if(d->character->lastaction + s->spell->cooldown > lastmillis || d->character->mana < s->spell->cost) return;
			d->character->lastaction = lastmillis;
			d->character->mana -= s->spell->cost;

			switch(s->spell->type)
			{
				case STYPE_TARGET:
					addspellprojectile(d, s);
					break;
				case STYPE_CONE:
					loopi(50) addspellprojectile(d, s, true);
					break;
				case STYPE_SELF:
					loopv(game::rpgobjs)
					{
						if(game::rpgobjs[i]->o.dist(d->o) <= s->spell->range)
							applyeffects(game::rpgobjs[i], s, d);
					}
					if(effects.inrange(s->spell->effect))
						playdeatheffect(d->abovehead(), effects[s->spell->effect], s->spell->range, vec(0,0,1), s);
					break;
				default:
					break;
			}
		}
	}

	void update()
	{
		loopv(game::rpgobjs)
		{
			rpgent &r = *game::rpgobjs[i];
			r.temp.dist = r.o.dist(game::player1->o);

			if(r.temp.dist <= rpgobjupdatedist)
			{
				switch(r.etype)
				{
					case ENT_CHAR:
						r.temp.fade = 1;
						if(r.state==CS_DEAD)
						{
							r.move = r.strafe = 0;
						}
						else if(r.state != CS_EDITING && r.character->health <= 0) r.die(lastmillis);

						if(r.state==CS_DEAD && r.ragdoll) moveragdoll(&r);
						else
						{
							if(r.ragdoll) cleanragdoll(&r);
							moveplayer(&r, i ? 2 : 10, r.state != CS_DEAD);
						}
						break;
					case ENT_ITEM:
					case ENT_SPELL:
						if(r.move || r.strafe) {r.move = r.strafe = 0;}
						moveplayer(&r, 2, false);
						break;
					default:
						break;
				}
			}
			switch(r.etype)
			{
				case ENT_CHAR:
					//update whenever there's status effects, or the character should be updated (this is set upon initialisation, and whenever anything in his inventory changes
					if(r.effects.length() || r.character->updatestats)
					{
						if(r.character->updatestats)
							r.character->updatestats = false;
						r.character->attributes = r.character->base;
						stats calc = stats(true); //for stats that get overwritten when calcattrs are called
						updateeffects(&r, calc);
						updateinv(&r, calc);
						r.character->attributes.limits(); //this is to ensure things arne't chaotic for the below items
						r.character->attributes.calcattrs();
						r.character->attributes.addall(calc);
						r.character->attributes.limits(); //insurance against overwhelmingly kewl lewt

						r.maxspeed = r.character->attributes.movespeed;
						r.jumpvel = r.character->attributes.jumpvel;
					}
					if(r.state!=CS_DEAD)
					{
						float recover = min(r.character->attributes.healthregen * curtime / 1000.0f, r.character->attributes.maxhealth - r.character->health);
						r.character->health += recover;

						recover = min(r.character->attributes.manaregen * curtime / 1000.0f, r.character->attributes.maxmana - r.character->mana);
						r.character->mana += recover;

						attack(&r);
					}
					updateprojs(&r);
					break;
				case ENT_ITEM:
				case ENT_SPELL:
				default:
					break;
			}
		}
	}
};
