#include "rpggame.h"

/*
This file is to contain ALL function exposed to cubescript that allow the scripting and configuration of entities and game objects
this involves simple things like setting the colour of a projectile to more complex ones like setting dialogue
*/

namespace rpgobj
{
	rpgent *getent(int i)
	{
		if(game::rpgobjs.inrange(i))
			return game::rpgobjs[i];

		return NULL;
	}

	int getident(rpgent *d)
	{
		loopv(game::rpgobjs)
		{
			if(d == game::rpgobjs[i])
				return i;
		}
		return -1;
	}

	//rpgent *getitement(rpgent *d, int i)

	//int getitemident(rpgent *d, rpgent *i)


	ICOMMAND(r_pickup, "ii", (int *d, int *i),
		rpgent *p = getent(*d);
		rpgent *s = getent(*i);
		if(!p || !s) return;
		pickup(p, s);
	);

	ICOMMAND(r_telemap, "is", (int *i, const char *map),
		rpgent *r = getent(*i);
		if(!r) return;
		if(r != game::player1)
		{
			game::rpgobjs.remove(*i);
			return;
		}
		game::transfer = true;
		load_world(map);
	);

	ICOMMAND(r_teleport, "ii", (int *i, int *d),
		rpgent *r = getent(*i);
		if(!r) return;
		entities::teleport(*r, *d);
	);

	ICOMMAND(r_say, "ss", (const char *t, const char *s),
		if(!game::lastcreated) return;
		rpgent *e = game::lastcreated;
		e->dialogue.add(new rpgchat(newstring(s), newstring(t)))
	);

	ICOMMAND(r_talk, "iii", (int *t, int *e, int *d),
		rpgent *r = getent(*t);
		rpgent *s = getent(*e);

		if(!r || !s || (r != game::player1 && s != game::player1)) return;

		if(r == game::player1)
			game::selected = s;
		else
			game::selected = r;

		//note -1 is closed
		game::selected->chatpos = *d;
		//the GUI will automatically open, as the chat hook looks for game::selected->chatpos >= 0
	);

	ICOMMAND(r_response, "sis", (const char *t, int *d, const char *s),
		if(!game::selected && !game::selected->dialogue.inrange(game::selected->chatpos)) return; //-1, aka closed will fail

		game::selected->dialogue[game::selected->chatpos]->dests.add(new response(newstring(t), *d, newstring(s)));
	);

	//TODO implement below
	//ICOMMAND(r_drop, "ii" ent item
	//ICOMMAND(r_applyeffect, "iiiii", ent effect strength duration element
	//ICOMMAND(r_destroy, "i" ent
	//ICOMMAND(r_reset, "ii" ent 'remove corpse'
	//ICOMMAND(r_trigger, "ii" ent status
	//ICOMMAND(r_face, "ii", target, ent

	ICOMMAND(r_addeffect, "iiii", (int *t, int *s, int *d, int *r),
		if(!game::lastcreated) return;
		rpgent *e = game::lastcreated;
		e->effects.add(status(*t, *s, *d, *r));
	);

	ICOMMAND(r_type, "i", (int *i),
		if(!game::lastcreated) return;
		rpgent *e = game::lastcreated;
		if(*i >= ENT_MAX || *i < 0) return;

		e->cleansubtypes();

		switch (e->etype = *i)
		{
			case ENT_CHAR:
				if(game::rpgobjs.length()-1) e->type = ENT_AI;
				else e->type = ENT_PLAYER;
				e->character = new rpgchar();
				break;
			case ENT_ITEM:
				e->type = ENT_INANIMATE;
				e->item = new rpgitem();
				break;
			case ENT_SPELL:
				e->type = ENT_INANIMATE;
				e->spell = new rpgspell();
				break;
			case ENT_OBJECT:
				e->type = ENT_INANIMATE;
				e->object = new rpgobject();
				break;
		}
	);


	ICOMMAND(r_additem, "s", (const char *s),
		if(!game::lastcreated) return;
		rpgent *e = game::lastcreated;

		if(!e->character) return;
		rpgent *item = new rpgent(DEFAULTMODEL);
		game::lastcreated = item;

		defformatstring(ds)("spawn_%s", s);
		execute(ds);

		if(item->etype == ENT_ITEM)
			e->character->inventory.add(item);
		else if(item->etype == ENT_SPELL)
			e->character->spellbook.add(item);
		else
		{
			conoutf("r_additem: Error adding item to \"%s\", \"%s\" is not a valid item type", e->name, item->name);
			delete item;
		}

		game::lastcreated = e;
	);

	#define N(b, n, f, t, c) ICOMMAND(r_ ## b ## _ ## n, f, (t *i), \
		rpgent *e = game::lastcreated; \
		if(!e || !e->b) return; \
		c \
	);
	#define NI(b, n) N(b, n, "i", int, e->b->n = *i)
	#define NF(b, n) N(b, n, "f", float, e->b->n = *i)
	#define NS(b, n) N(b, n, "s", const char, if(e->b->n) {delete[] e->b->n;} e->b->n = newstring(i))
	#define NB(b, n) N(b, n, "i", int, e->b->n = *i != 0)

	NB(object, active);

	NI(item, slots);

	NI(spell, cooldown);
	NI(spell, range);
	NI(spell, type);
	NI(spell, cost);
	NI(spell, castdelay);
	NI(spell, effect);
	NI(spell, fade);
	NI(spell, gravity);

	//TODO redefine N here for the above for the sole purpose of r_get functionality

	#undef N
	#undef NI
	#undef NF
	#undef NS
	#undef NB

	#define N(n, f, t, c) ICOMMAND(r_##n, f, (t *i), \
		rpgent *e = game::lastcreated; \
		if(!e) return; \
		c; \
	);

	#define NI(n) N(n, "i", int, e->n = *i)
	#define NF(n) N(n, "f", float, e->n = *i)
	#define NS(n) N(n, "s", const char, if(e->n) {delete[] e->n;} e->n = newstring(i))
	#define NB(n) N(n, "i", int, e->n = *i != 0)

	NS(icon);
	NS(model);
	NS(name);
	NS(description);
	NS(death);
	NS(interact);
	NS(approach);

	#undef N

	#define N(n, f, t, c) ICOMMAND(r_proj_##n, f, (t *i), \
		if(!effects.length()) \
		{ \
			conoutf("error: no effects (use r_proj_new)"); \
			return; \
		} \
		projeffect *e = effects[effects.length()-1]; \
		c; \
	);

	ICOMMAND(r_proj_new, "", (), effects.add(new projeffect()););
	//simplifies variable configuration commands

	NB(dynlight);
	NB(trail);

	NI(basevel);
	NI(kickback);
	NI(trailpart);
	NI(trailcol);
	NI(trailfade);
	NI(gravity);
	NI(projpart);
	NI(projcol);
	NI(lightradius);
	NI(lightcolour);
	NI(deathpart);
	NI(deathpartcol);
	NI(deathfade);
	NI(deathdecal);
	NI(deathlightflags);
	NI(deathlightinitcol);
	NI(deathlightfade);
	NI(deathdecal);

	NF(trailsize);
	NF(projsize);
	NF(deathpartsize);


	NS(mdl);

	#undef NB
	#undef NI
	#undef NF
	#undef NS
	#undef N
};