#include "sspgame.h"

namespace game
{
	int  maptime = 0, secsremain = 0, secsallowed, cameraent, lastcameraent, cameramillis;
	// time started / time left / time allowed / camera / last camera / camera assignment time
	bool intermission;
	string clientmap;

	sspent *player1 = new sspent();
	sspent lastplayerstate;

	//items
	vector<pickup *> pickups[PICKUP_MAX];

	vector<eventimage *> eventimages;

	ICOMMAND(map, "s", (char *s), load_world(s));

	ICOMMAND(addcoin, "si", (char *s, int *x), pickups[PICKUP_COIN].add(new pickup (PICKUP_COIN, s, *x, 0, 0, "")));
	ICOMMAND(addhealth, "si", (char *s, int *x), pickups[PICKUP_HEALTH].add(new pickup (PICKUP_HEALTH, s, *x, 0, 0, "")));
	ICOMMAND(addtime, "si", (char *s, int *x), pickups[PICKUP_TIME].add(new pickup (PICKUP_TIME, s, *x, 0, 0, "")));
	ICOMMAND(addlife, "si", (char *s, int *x), pickups[PICKUP_LIVES].add(new pickup (PICKUP_LIVES, s, *x, 0, 0, "")));

	ICOMMAND(addweapon, "ssiii", (char *s, char *t, int *x, int *y, int *z), pickups[PICKUP_WEAPON].add(new pickup(PICKUP_WEAPON, s, *x, *y, *z, t)));
	ICOMMAND(addarmour, "ssi", (char *s, char *t, int *x), pickups[PICKUP_ARMOUR].add(new pickup(PICKUP_ARMOUR, s, *x, 0, 0, t)));

	ICOMMAND(resetpickups, "", (), loopi(PICKUP_MAX) {pickups[i].setsizenodelete(0);});

	ICOMMAND(eventimage, "si", (char *s, int *x), eventimages.add(new eventimage(s, *x)));

	ICOMMAND(getyaw, "", (), defformatstring(s)("%f", player1->yaw); result(s););

	//movement
	void switchaxis() //flip the rotation if a player is close to an axis entity, try to make it automatic eventually
	{
		loopv(entities::ents)
		{
			extentity &e = *entities::ents[i];
			if(e.type !=AXIS) continue;
			vec pos1 = e.o;
			vec pos2 = player1->o;
			pos1.z = pos2.z = 0;

			if(pos1.dist(pos2) <= (e.attr4 ? abs(e.attr4) : 16) && abs(player1->o.z-e.o.z) <= (e.attr5 ? abs(e.attr5) : 64))
			{
				vec pos = player1->o;
				if((int) player1->yaw % 180 == e.attr1 % 180)
					player1->yaw = e.attr2;
				else
					player1->yaw = e.attr1;

				player1->newpos = e.o;
				player1->vel = vec(0, 0, player1->vel.z);
				player1->newpos.z = pos.z;

				defformatstring(id)("axis_script_%i", e.attr3); //ie, to change cameras
				if(identexists(id)) execute(id);
				return;
			}
		}
	}
	ICOMMAND(switchaxis, "", (), switchaxis());

	int closestyaw(physent *d)
	{
		int yaw = d->yaw; //ignore decimals
		if(yaw>= 45 && yaw <= 134)
			return 90;

		else if(yaw >= 135 && yaw <= 224)
			return 180;

		else if(yaw>=225 && yaw<=314)
			return 270;

		else
			return 0;
	}

	void changeyaw(int val1, int val2) //done seperately to avoid undoing yaw changes
	{
		int yaw = closestyaw(camera1);
		int playeryaw = player1->yaw;
		if(playeryaw != (yaw+val1) % 360 && playeryaw != (yaw+val2) % 360)
		{
			player1->yaw = (playeryaw+180) % 360; //test failed, turn around
		}
	}

	void moveright(int down) //if cam.yaw == 0, then right = 0 && 90
	{
		changeyaw(0, 90);
		player1->k_up = down!=0;
		player1->move = player1->k_up ? 1 : (player1->k_down ? -1 : 0);
	}

	void moveleft(int down)
	{
		changeyaw(180, 270);
		player1->k_down = down!=0;
		player1->move = player1->k_down ? 1 : (player1->k_up ? -1 : 0);
	}
	ICOMMAND(moveright, "D", (int *down), { moveright(*down); });
	ICOMMAND(moveleft, "D", (int *down), { moveleft(*down); });

	const char *getclientmap() { return clientmap; }
	void resetgamestate() {}

	void takedamage(sspent *d, int damage, int invuln)
	{
		if(d->lastpain + invuln > lastmillis) return;

		if(d->armour)
			d->armour = ARM_NONE;
		else
			d->health -= damage;

		d->lastpain = lastmillis;
	}

	void suicide(physent *d)
	{
		if(d==player1 && player1->state==CS_ALIVE)
		{
			//to ponder... should the player shoot into the air, or just scream owie for a bit
			takedamage(player1, 1, 2000); //just give the player a booboo, don't kill him :P
		}
		else if(d->type==ENT_AI && d->state==CS_ALIVE)
		{
			takedamage((sspent *)d, 1, 1000);
			d->vel = d->falling = vec(0, 0, 0);
			d->vel.z = 100.0f;
		}
	}

	sspent *spawnstate(sspent *d)              // reset player state not persistent accross spawns
	{
		d->respawn();
		return d;
	}

	void spawnplayer(sspent *d)   // place at random spawn. also used by monsters!
	{
		if (d==player1)
		{
			if (entities::ents.inrange(d->checkpoint)) d->yaw = entities::ents[d->checkpoint]->attr1;
			findplayerspawn(d, d->checkpoint>=0 ? d->checkpoint : -1, 0);
		}
		else
			findplayerspawn(d, -1, 0);
		spawnstate(d);
		d->state = d==player1 && editmode ? CS_EDITING : CS_ALIVE;
		d->lastpain = lastmillis;
	}

	void respawnself()
	{
		spawnplayer(player1);
	}

	void fixplayeryaw()
	{
		//constrains player's yaw to 90 degree angles, round up
		player1->yaw = closestyaw(player1);
	}

	void getcamera()
	{
		defformatstring(s)("%i", cameraent<0 ? -1 : entities::ents[cameraent]->attr1);
		result(s);
	}
	ICOMMAND(getcamera, "", (), getcamera(););

	//set cameraent to the valid ent if it exists, otherwise, just ignore the request
	void setcamera(int attr1)
	{
		loopv(entities::ents)
		{
			extentity &e = *entities::ents[i];
			if(e.type == CAMERA && e.attr1 == attr1)
			{
				lastcameraent = cameraent;
				cameramillis = lastmillis;
				cameraent = i;
				return;
			}
		}
	}
	ICOMMAND(setcamera, "i", (int *x), { setcamera(*x);});

	void setwindowcaption()
	{
		defformatstring(capt)("Sandbox %s: Side Scrolling Platformer - %s", version, getclientmap()[0] ? getclientmap() : "[new map]");
		SDL_WM_SetCaption(capt, NULL);
	}

	void startmap(const char *name)   // called just after a map load
	{
		secsallowed = 300;

		player1->checkpoint = -1;
		cameraent = lastcameraent = -1;

		setcamera(0); //set the camera if it exists

        	copystring(clientmap, name ? name : "");
		intermission = false;
		maptime = cameramillis = lastmillis;
		entities::prepareents();
		initialisemonsters();
		findplayerspawn(player1, -1);
		player1->lastpain = lastmillis; //for spawning invulnerability
        	conoutf(CON_GAMEINFO, "\f2D to move right, A to move left, W to jump, and click to attack, have fun!");

        	if(identexists("mapstart")) execute("mapstart");
	}

	void respawn()
	{
		if(player1->state==CS_DEAD)
		{
			player1->attacking = false;
			if(player1->lives > 0)
			{
				respawnself();
				player1->lives--;
			}
			else
			{
				player1->lives = 6; //i-1
				changemap(getclientmap());
			}
		}
	}

	void doattack(bool on)
	{
		if(intermission) return;
		if((player1->attacking = on)) respawn();
	}
	ICOMMAND(attack, "D", (int *down), { doattack(*down!=0); });

	bool canjump()
	{
		if(!intermission) respawn();
		return player1->state!=CS_DEAD && !intermission;
	}

	bool allowdoublejump()
	{
		if(player1->armour==ARM_FLY && lastmillis - player1->lastjump > 600) return true;
		return false;
	}

	bool detachcamera()
	{
		return !editmode; //we want the camera detached if the player isn't editing;
   	}

	void updatecamera()
	{
		if (editmode) return;
		physent &newcam = *camera1;

		float dist = 100, pitch = 0, yaw = 0;
		if(entities::ents.inrange(cameraent))
		{
			if(cameramillis + 750 > lastmillis)
			{
				//basic interpolation, simply a transition between two cameras, values above 360 and below 0 are allowed for yaw
				float mult = (lastmillis - cameramillis) / 750.0f, deltayaw, deltapitch, deltadist;

				if(entities::ents.inrange(lastcameraent))
				{
					deltayaw = entities::ents[lastcameraent]->attr2 - entities::ents[cameraent]->attr2;
					deltapitch = entities::ents[lastcameraent]->attr3 - entities::ents[cameraent]->attr3;
					deltadist = entities::ents[lastcameraent]->attr4 - entities::ents[cameraent]->attr4;

					yaw = entities::ents[lastcameraent]->attr2;
					pitch = entities::ents[lastcameraent]->attr3;
					dist = entities::ents[lastcameraent]->attr4;
				}
				else
				{
					deltayaw = 0 - entities::ents[cameraent]->attr2;
					deltapitch = 0 - entities::ents[cameraent]->attr3;
					deltadist = 100 - entities::ents[cameraent]->attr4;
				}

				yaw -= deltayaw * mult;
				pitch -= deltapitch * mult;
				dist -= deltadist * mult;
			}
			else
			{
				yaw = entities::ents[cameraent]->attr2;
				pitch = entities::ents[cameraent]->attr3;
				dist = entities::ents[cameraent]->attr4;
			}
		}

		newcam.yaw = yaw;
		newcam.pitch = (90 < pitch ? 90 : (-90 > pitch ? -90 : pitch));

		vec dir; vecfromyawpitch(newcam.yaw, newcam.pitch, -1, 0, dir);
		movecamera(&newcam, dir, dist, 1);
		movecamera(&newcam, dir, clamp(dist - newcam.o.dist(player1->o), 0.0f, 1.0f), 0.1f);
		//loopi(10) moveplayer(&newcam, 10, true, dist);
	}

	void updateworld()        // main game update loop
	{
		if(editmode)
		{
			secsremain = 300;
			intermission = false;
			maptime = lastmillis;
		}
		else
		{
			player1->pitch = 0;
			setvar("zoom", -1, true);
			setvar("fov", 100, true); //no zooming :D
			fixplayeryaw();
		}

		if (!intermission) secsremain = secsallowed - (lastmillis - maptime)/1000;
		if (secsremain <= 0) intermission = true;

		if(!curtime) return;

		physicsframe();
		updatemonsters();
		updateprojs();

		if(player1->state==CS_DEAD)
		{
			if(player1->ragdoll) moveragdoll(player1);
			else
			{
				player1->move = player1->strafe = 0;
				moveplayer(player1, 10, false);
			}

		}
		else if(!intermission)
		{
			entities::checkitems(player1);
			moveplayer(player1, 10, true);

			//other monitoring stuff
			if(player1->health<=0 && player1->state==CS_ALIVE)
			{
				player1->state = CS_DEAD;
				eventimages.add(new eventimage("data/hirato/ssp/died", 2000));
			}
			for(; player1->coins>= 100 && player1->lives < 99;) //change every 100 coins into a life, assuming the amount is below 99, yay!
			{
				player1->lives++;
				player1->coins -= 100;
			}
		}

		if(intermission)
		{
			clearprojs();
		}
	}


	void quad(int x, int y, int xs, int ys)
	{
		glBegin(GL_QUADS);
		glTexCoord2f(0, 0); glVertex2i(x,    y);
		glTexCoord2f(1, 0); glVertex2i(x+xs, y);
		glTexCoord2f(1, 1); glVertex2i(x+xs, y+ys);
		glTexCoord2f(0, 1); glVertex2i(x,    y+ys);
		glEnd();
	}

	float abovegameplayhud() {return 1;}

	void gameplayhud(int w, int h)
	{
		glPushMatrix();
		glScalef(1, 1, 1);

		int width = (w - 512) / 2, height = (h-512) / 2;
		loopv(eventimages)
		{
			eventimage &img = *eventimages[i];

			if(img.deltime < lastmillis) eventimages.remove(i);

			settexture(img.tex, 3);
			if(img.deltime - lastmillis <= 500)
				glColor4f(1, 1, 1, (img.deltime - lastmillis) / 500.0);
			else if(lastmillis - img.starttime <= 200)
				glColor4f(1, 1, 1, (lastmillis - img.starttime) / 200.0);
			else
				glColor4f(1, 1, 1, 1);

			quad(width, height, 512, 512);

			settexture("data/hud/2.3/guioverlay", 3);
			quad(width, height, 512, 512);

		}

		width = max(w, h)/32;
		draw_textf("%d", 4*width , h-3.5*width, player1->lives);
		draw_textf("%d", 16*width, h-2*width, secsremain);
		draw_textf("%d", 27*width, h-2*width, player1->coins);

		settexture("data/hud/2.3/icons/rc", 3); //character

		if(lastmillis < player1->lastpain + 2000)
			glColor4f(1, .5, .5, 1); //set colours, he obviously had a recent owie
		else
			glColor4f(1, 1, 1, 1);

		quad(.5 * width, h - 4 * width, 3*width, 3*width);

		settexture("data/hirato/hp", 3); //HP, try a cube or something
		glColor4f(1- (0.5f * (player1->health - 1)), 0.5f * (player1->health - 1) , 0, 1);
		loopi(player1->health)
		{
			quad((4 + 1.25 * i) * width, h - 2*width, width, width);
		}

		settexture("data/hirato/time", 3); //clock
		glColor4f(1, 1, 1, 1);
		quad(13*width, h- 3*width, 2*width, 2*width);

		settexture("data/hirato/coin", 3); //bling bling!
		glColor4f(1, 1, 1, 1);
		quad(24*width, h-3*width, 2*width, 2*width);

		settexture("data/hirato/shield", 3); //are you protected? :P
		switch(player1->armour)
		{
			case ARM_PLAIN:
				glColor4f(.75, 1, .5, 1);
				break;
			case ARM_ATTRACT:
				glColor4f(0., .5, 1, 1);
				break;
			case ARM_FLY:
				glColor4f(1, 1, 1, 1);
				break;
			case ARM_SPIKE:
				glColor4f(0.75, 0.75, 0.75, 1);
				break;
			default:
				glColor4f(1, 1, 1, .25);
				break;
		}
		quad(0.5 * width, h - 6.5 * width, 2*width, 2*width);

		glPopMatrix();
	}

	const char *getmapinfo() { return "";}

	int clipconsole(int w, int h)
	{
		return 0;
	}
	const char *defaultcrosshair(int index)
	{
		//memo to self, make 1^2 px crosshair
		return editmode ? "data/edit" : "data/items";
	}

	int selectcrosshair(float &r, float &g, float &b)
	{
		r = b = 0.5;
		g = 1.0f;
		return editmode;
	}

	void initclient()
	{
		clientmap[0] = 0;
	}

	void newmap(int size) { copystring(clientmap, "untitled"); }

	void physicstrigger(physent *d, bool local, int floorlevel, int waterlevel, int material)
	{
		if(d->state!=CS_ALIVE) return;
		switch(material)
		{
			case MAT_LAVA:
				if (waterlevel==0) break;
				playsound(S_BURN, d==player1 ? NULL : &d->o);
				loopi(60)
				{
					vec o = d->o;
					o.z -= d->eyeheight *i/60.0f;
					regularflame(PART_FLAME, o, 6, 2, 0x903020, 3, 2.0f);
					regularflame(PART_SMOKE, vec(o.x, o.y, o.z + 8.0f), 6, 2, 0x303020, 1, 4.0f, 100.0f, 2000.0f, -20);
				}
				break;
			case MAT_WATER:
				if (waterlevel==0) break;
				playsound(waterlevel > 0 ? S_SPLASH1 : S_SPLASH2 , d==player1 ? NULL : &d->o);
				particle_splash(PART_WATER, 200, 200, d->o, (watercolor.x<<16) | (watercolor.y<<8) | watercolor.z, 0.5);
			default:
				if (floorlevel==0) break;
				playsound(floorlevel > 0 ? S_JUMP : S_LAND, local ? NULL : &d->o);
				break;
		}
	}

	int numdynents() { return 1+monsters.length()+entities::items.length(); }

	dynent *iterdynents(int i)
	{
		if(!i) return player1;
		i--;
		if(i<monsters.length()) return (dynent *)monsters[i];
		i -= monsters.length();
		if(i<entities::items.length()) return (dynent *)entities::items[i];
		//i -= entities::items.length();
		return NULL;
	}

	void edittrigger(const selinfo &sel, int op, int arg1, int arg2, int arg3) {}

	void writemapdata(stream *f)
	{
		f->printf("resetpickups\n\n");
		loopi(PICKUP_MAX)
		{
			loopvj(pickups[i])
			{
				pickup &p = *pickups[i][j];
				switch(i)
				{
					case PICKUP_COIN:
					case PICKUP_TIME:
					case PICKUP_LIVES:
					case PICKUP_HEALTH:
						f->printf("add%s %s %i\n", i==PICKUP_COIN ? "coin" : i==PICKUP_TIME ? "time" : i==PICKUP_LIVES ? "life" : "health", p.mdl, p.amount);
						break;
					case PICKUP_WEAPON:
						f->printf("addweapon %s %s %i %i %i\n", p.mdl, p.attachmdl, p.projectile, p.sound, p.cooldown);
						break;
					case PICKUP_ARMOUR:
						f->printf("addarmour %s %s %i", p.mdl, p.attachmdl, p.type);
						break;
				}
			}
			f->printf("\n");
		}
		writemonsters(f);
		writeprojectiles(f);
	}


	void openworld(const char *name, bool fall = false)
	{
		string tmp;
		formatstring(tmp)("packages/base/%s.ogz", name);
		if(fileexists(tmp, "r")) load_world(name);
		else if(fall) //a fallback
			load_world("ssptest");
	}

	void changemap(const char *name) { openworld(name, true); }
	void forceedit(const char *name) { openworld(name); }

	bool showenthelpers() { return editmode; }

	void writegamedata(vector<char> &extras) {}
	void readgamedata(vector<char> &extras) {}

	const char *gameident() { return "ssp"; }
	const char *defaultconfig() { return "data/defaults.cfg"; }
	const char *autoexec() { return "autoexec.cfg"; }
	const char *savedservers() { return ""; } //stub
	const char *loadimage() { return "data/sandbox_ssp_logo"; }
	void loadconfigs() {}
	void texturefailed(char *name, int slot) {}
        void mmodelfailed(const char *name, int idx) {}
        void mapfailed(const char *name) {}
}

