#include "sspgame.h"

namespace entities
{
	vector<extentity *> ents;

	vector<extentity *> &getents() { return ents; }
	extentity *newentity() { return new sspentity(); }
	void deleteentity(extentity *e) { delete (sspentity *)e; }

	vector<item *> items;

	const char *entmodel(const entity &e)
	{
		switch(e.type)
		{
			case TELEPORT:
				return mapmodelname(e.attr3);
				break;
			default: return NULL;
		}
	}

	int testdist(extentity &e)
	{
		switch(e.type)
		{
			case TELEPORT:
			case CHECKPOINT:
				return e.attr2 != 0 ? abs(e.attr2) : 16;
			case JUMPPAD:
				return e.attr4 != 0 ? abs(e.attr4) : 12;
			case AXIS:
				return e.attr4 != 0 ? abs(e.attr4) : 16;
		}
		return 24;
	}

	int pickupdist()
	{
		if(game::pickups[PICKUP_ARMOUR].inrange(game::player1->armourvec) && game::player1->armour==ARM_ATTRACT)
			return 48;
		else
			return 12; //quadruple distance for attractive armour
	}

	void fixentity(extentity &e)
	{
		switch(e.type)
		{
			case BOX:
			case ENEMY:
			case TELEDEST:
			case CHECKPOINT:
			case PLATFORM:
			{
				e.attr5 = e.attr4;
				e.attr4 = e.attr3;
				e.attr3 = e.attr2;
				e.attr2 = e.attr1;
				e.attr1 = game::player1->yaw;
				break;
			}
		}
	}

	bool teleport(sspent *d, int dest)
	{
		loopv(ents)
		{
			extentity &e = *ents[i];
			if(e.type==TELEDEST && e.attr2 == dest)
			{
				d->o = d->newpos = vec(e.o).add(vec(0, 0, d->eyeheight));
				d->vel = d->falling = vec(0,0,0);
				d->yaw = abs(e.attr1) % 360;
				particle_splash(PART_EDIT, 1250, 750, e.o, d==game::player1 ? 0x0000FF : 0xFF0000, 1.0f, 150, 0x7FFFFF);
				playsound(S_TELEPORT, &e.o);
				return true;

			}
		}
		conoutf("no such teledest: %i", dest);
		return false;
	}

	bool pickuppowerup(sspent *d, item &i)
	{
		if(d!=game::player1 || ((i.index[0] < 0 || i.index[0] >= PICKUP_MAX) || !game::pickups[i.index[0]].inrange(i.index[1]))) return false; //we currently only want the player to be able to pickup these powerups, hopefully having the checks for valid ent attributes will prevent crashes

		vec emit = i.o;
		emit.z += 5;
		pickup &p = *game::pickups[i.index[0]][i.index[1]]; //looks like some sort of mutant matrix :D, but it gets the type specified in attr1 of index attr2
		string ds;
		bool pickedup = false;

		switch(i.index[0])
		{
			case PICKUP_COIN:
				pickedup = true;
				game::player1->coins += p.amount;
				formatstring(ds)("@%i coin%s", p.amount, p.amount==1 ? "" : "s");
				particle_text(emit, ds, PART_TEXT, 2000, 0xffd700, 8.0f, -8);
				break;

			case PICKUP_HEALTH:
				if(p.amount>0 && game::player1->maxhealth <= game::player1->health) break; //keeps useful pickups from dissapearing, if you've no need of them yet
				pickedup = true;
				game::player1->health = min(game::player1->maxhealth, game::player1->health + p.amount); //fully heals players or hurts
				if(p.amount<0) game::player1->lastpain = lastmillis; //my tummy hurts :(
				formatstring(ds)("@%i HP", p.amount);
				particle_text(emit, ds, PART_TEXT, 2000, p.amount>=0 ? 0x00FF00 : 0xFF0000, 8.0f, -8);
				break;

			case PICKUP_TIME:
				pickedup = true;
				game::secsallowed += p.amount;
				formatstring(ds)("@%i second%s", p.amount, p.amount==1 ? "" : "s");
				particle_text(emit, ds, PART_TEXT, 2000, p.amount>= 0 ? 0xAFAFAF : 0xFF0000, 8.0f, -8);
				break;;

			case PICKUP_LIVES:
				if(p.amount>0 && game::player1->lives != 99)
				{
					pickedup = true;
					game::player1->lives = min(99, game::player1->lives + p.amount);
					formatstring(ds)("@%i %s", p.amount, p.amount>1 ? "lives" : "life");
					particle_text(emit, ds, PART_TEXT, 2000, 0xffd700, 8.0f, -8);
				}
				break;

			case PICKUP_WEAPON:
				pickedup = true;
				game::player1->gunselect = i.index[1]; //set the player equipped weapon to the valid part of the vector for fire sound and projectile information
				break;

			case PICKUP_ARMOUR:
			{
				pickedup = true;
				game::player1->armourvec = i.index[1];
				game::player1->armour = p.type;
				const char *type[ARM_MAX] = {"", "Plain", "Attractive", "Winged", "Spiked"};
				formatstring(ds)("@%s Armour", type[p.type]);
				particle_text(emit, ds, PART_TEXT, 2000, 0x007FFF, 8.0f, -8);
			}
				break;

			default:
				break;
		}
		if (pickedup) particle_splash(PART_STEAM, 200, 200, emit, 0xCFCFCF, 1, 150, -10);
		return pickedup;
	}

	void trypickup(int n, sspent *d)
	{
		switch(ents[n]->type)
		{
			case TELEPORT:
				if(lastmillis < d->lastpickupmillis + 200) return;
				if(teleport(d, ents[n]->attr1))
					playsound(S_TELEPORT, &ents[n]->o);
				d->lastpickupmillis  = lastmillis;
				return;
			case JUMPPAD:
				if(lastmillis < d->lastpickupmillis + 200) return;
				d->falling = vec(0, 0, 0);
				d->vel.z = ents[n]->attr1 * 10;
				d->vel.y += ents[n]->attr2 * 10;
				d->vel.x += ents[n]->attr3 * 10;
				playsound(S_JUMPPAD, &ents[n]->o);
				d->lastpickupmillis = lastmillis;
				return;
			case CHECKPOINT:
				if(d==game::player1 && n!=game::player1->checkpoint)
				{
					vec emit = ents[n]->o;
					emit.z += 5;
					game::player1->checkpoint = n;
					defformatstring(ds)("@Checkpoint!");
					particle_text(emit, ds, PART_TEXT, 2000, 0x7FFF7F, 8.0f, -8);
				}
				game::player1->lastpickupmillis  = lastmillis;
				return;
		}
	}

	void checkitems(sspent *d)
	{
		if(d==game::player1 && editmode) return;
		vec o = d->o;
		o.z -= d->eyeheight;
		loopv(ents)
		{
			extentity &e = *ents[i];
			if(e.type==NOTUSED) continue;
			if(!e.spawned && e.type!=TELEPORT && e.type!=JUMPPAD && e.type!=CHECKPOINT) continue;
			float dist = e.o.dist(o);
			if(dist<testdist(e)) trypickup(i, d);
		}

		loopv(items)
		{
			item &p = *items[i];
			float dist = p.o.dist(o);
			if(dist<pickupdist())
			{
				if(game::pickups[PICKUP_ARMOUR].inrange(game::player1->armourvec) && game::player1->armour==ARM_ATTRACT)
					regularshape(PART_LIGHTNING, 8, 0x007FFF, 31, 2, 200, vec(p.o.x+rnd(8)-4, p.o.y+rnd(8)-4, p.o.z+rnd(8)), .25, 0, 0 ); //make it look pretty

				vec deltapos = vec(o).sub(p.o);
				deltapos.mul(curtime/400.0f); // *1000/0.4, reduce the distance by ~40% over the course of a second
				p.o.add(deltapos);
				if(dist<6)
				{
					if(pickuppowerup(d, p)) { items.remove(i); i--;}
				}
			}
		}
	}

	void renderent(extentity &e, const char *mdlname, float z, float yaw, int anim = ANIM_MAPMODEL)
	{
		if(!mdlname) return;
		rendermodel(&e.light, mdlname, anim|ANIM_LOOP, vec(e.o).add(vec(0, 0, z)), yaw, 0, MDL_SHADOW | MDL_CULL_VFC | MDL_CULL_DIST | MDL_CULL_OCCLUDED);
	}

	void renderentities()
	{
		loopv(ents)
		{
			extentity &e = *ents[i];
			switch(e.type)
			{
				case TELEPORT:
					renderent(e, mapmodelname(e.attr3), (float)(1+sin(lastmillis/100.0+e.o.x+e.o.y)/20), lastmillis/10.0f);
					continue;
				case CHECKPOINT:
					renderent(e, "butterfly", 0, e.attr1, ANIM_IDLE);
					continue;
				case AXIS:
				{
					int radius = e.attr4 ? abs(e.attr4) : 16;
					vec dir = vec(0, 0, 0);
					vecfromyawpitch(e.attr1, 0, 1, 0, dir);
					dir.mul(radius);
					dir.add(e.o);
					particle_flare(e.o, dir, 1, PART_STREAK, 0x007FFF, 0.4);

					vecfromyawpitch(e.attr2, 0, 1, 0, dir);
					dir.mul(radius);
					dir.add(e.o);
					particle_flare(e.o, dir, 1, PART_STREAK, 0x007FFF, 0.4);
					continue;
				}
				default:
					continue;
			}
		}
		loopv(items)
		{
			item &p = *items[i];
			if(p.index[0] < 0 || p.index[0] >= PICKUP_MAX || !game::pickups[p.index[0]].inrange(p.index[1])) continue;

			rendermodel(&p.light, game::pickups[p.index[0]][p.index[1]]->mdl,
				ANIM_MAPMODEL|ANIM_LOOP, vec(p.o).add(vec(0, 0, (float)(1+sin(lastmillis/100.0+p.o.x+p.o.y)/20))),
				lastmillis/10.0f, 0, MDL_SHADOW|MDL_CULL_VFC|MDL_CULL_DIST|MDL_CULL_OCCLUDED|MDL_LIGHT
			);
		}
	}

	void entradius(extentity &e, bool &color)
	{
		switch(e.type)
		{
			case AXIS:
			{
				vec dir;

				vecfromyawpitch(e.attr1, 0, 1, 0, dir);
				renderentarrow(e, dir, testdist(e));

				vecfromyawpitch(e.attr2, 0, 1, 0, dir);
				renderentarrow(e, dir, testdist(e));

				break;
			}
			case ENEMY:
			case TELEDEST:
			case CHECKPOINT:
			case PLATFORMROUTE:
			{
				vec dir;
				vecfromyawpitch(e.attr1, 0, 1, 0, dir);
				renderentarrow(e, dir, 4);
				break;
			}
			case CAMERA:
			{
				vec dir;
				vecfromyawpitch(e.attr2, e.attr3, 1, 0, dir);
				renderentarrow(e, dir, 4);
				break;
			}
			case WAYPOINT:
				loopv(ents)
				{
					if(ents[i]->type == WAYPOINT && e.attr2==ents[i]->attr2)
					{
						renderentarrow(e, vec(ents[i]->o).sub(e.o).normalize(), e.o.dist(ents[i]->o));
						break;
					}
				}
				break;
			case TELEPORT:
				loopv(ents)
				{
					if(ents[i]->type == TELEDEST && e.attr1==ents[i]->attr2)
					{
						renderentarrow(e, vec(ents[i]->o).sub(e.o).normalize(), e.o.dist(ents[i]->o));
						renderentsphere(e, testdist(e) );
						break;
					}
				}
                		break;
			case JUMPPAD:
				renderentarrow(e, vec((int)(char)e.attr3*10.0f, (int)(char)e.attr2*10.0f, e.attr1*12.5f).normalize(), testdist(e));
				renderentsphere(e, testdist(e));
				break;
		}
	}

	bool radiusent(extentity &e)
	{
		switch(e.type)
		{
			case LIGHT:
			case ENVMAP:
			case MAPSOUND:
			case JUMPPAD:
			case TELEPORT:
				return true;
				break;
			default:
				return false;
				break;
		}
	}

	bool dirent(extentity &e)
	{
		switch(e.type)
		{
			case AXIS:
			case MAPMODEL:
			case PLAYERSTART:
			case SPOTLIGHT:
			case ENEMY:
			case WAYPOINT:
			case TELEPORT:
			case TELEDEST:
			case CHECKPOINT:
			case JUMPPAD:
			case PLATFORMROUTE:
			case CAMERA:
				return true;
				break;
			default:
				return false;
				break;
		}
	}

	void prepareents()
	{
		items.setsizenodelete(0);
		loopv(ents)
		{
			extentity &e = *ents[i];
			switch(e.type)
			{
				case PICKUP:
					items.add(new item(e.o, e.attr1, e.attr2, false, 0));
					continue;
				case BOX:
				case ENEMY:
				case PLATFORM:
					continue; //TODO, box enemy and platform spawning
			}
		}
	}

	bool printent(extentity &e, char *buf)
	{
		return false;
	}

	const char *entnameinfo(entity &e) { return ""; }
	int extraentinfosize() {return 0;}

	const char *entname(int i)
	{
		static const char *entnames[] =
		{
			"none?", "light", "mapmodel", "playerstart", "envmap", "particles", "sound", "spotlight", "box", "pickup",
			"enemy", "waypoint", "teleport", "teledest", "checkpoint", "jumppad", "platform", "platformroute", "camera", "axis", "", "", ""
		};
	return i>=0 && size_t(i)<sizeof(entnames)/sizeof(entnames[0]) ? entnames[i] : "";
	}

	void renderhelpertext(extentity &e, int &colour, vec &pos, string &tmp)
	{
		switch(e.type)
		{
			case BOX:

				return;
			case PICKUP:
				pos.z += 3.0;
				formatstring(tmp)("Type: %s (%i)\nIndex: %i",
					e.attr1 == 0 ? "Coin" : e.attr1 == 1 ? "Weapon" : e.attr1 == 2 ? "Armour" : e.attr1 == 3 ? "Health" : e.attr1 == 4 ? "Time" : "Lives", e.attr1,
					e.attr2
				);
				return;
			case ENEMY:
				pos.z += 3.0;
				formatstring(tmp)("Yaw: %i\nIndex: %i",
					e.attr1,
					e.attr2
				);
				return;
			case WAYPOINT:

				return;
			case TELEPORT:
				pos.z += 4.5;
				formatstring(tmp)("Teleport Tag: %i\nRadius: %i\nModel: %s (%i)",
					e.attr1,
					e.attr2,
					mapmodelname(e.attr3), e.attr3
				);
				return;
			case TELEDEST:
				pos.z += 3.0;
				formatstring(tmp)("Yaw: %i\nTeleport Tag: %i",
					e.attr1,
					e.attr2
				);
				return;
			case CHECKPOINT:
				pos.z += 1.5;
				formatstring(tmp)("Yaw: %i",
					e.attr1
				);
				return;
			case JUMPPAD:
				pos.z += 6.0;
				formatstring(tmp)("Z: %i\nY: %i\nX: %i\nRadius: %i",
					e.attr1,
					e.attr2,
					e.attr3,
					e.attr4
				);
				return;
			case PLATFORM:

				return;
			case PLATFORMROUTE:

				return;
			case CAMERA:
				pos.z += 6.0;
				formatstring(tmp)("Tag: %i\nYaw: %i\nPitch: %i\n Distance: %i",
					e.attr1,
					e.attr2,
					e.attr3,
					e.attr4
				);
				return;
			case AXIS:
				pos.z += 7.5;
				formatstring(tmp)("Yaw1: %i\nYaw2:\nTag: axis_script_%i\nRadius: %i\nVert Radius: %i",
					e.attr1,
					e.attr2,
					e.attr3,
					e.attr4,
					e.attr5
				);
				return;
		}
	}

	void writeent(entity &e, char *buf) {}  // write any additional data to disk (except for ET_ ents)

	void readent(entity &e, char *buf)     // read from disk, and init
	{
		//int ver = getmapversion(); //commented only because it'd unused
	}

	float dropheight(entity &e)
	{
		if (e.type==MAPMODEL) return 0.0f;
		return 4.0f;
	}

	void clearents()
	{
		while(ents.length()) deleteentity(ents.pop());
	}

	//stubs
	void editent(int i) {}
	void rumble(const extentity &e) {}
	void trigger(extentity &e){}
	bool mayattach(extentity &e) { return false; }
	bool attachent(extentity &e, extentity &a) { return false; }

	int *getmodelattr(extentity &e)
	{
		switch(e.type)
		{
			case TELEPORT:
				return &e.attr3;
			default:
				return NULL;
		}
	}

	bool checkmodelusage(extentity &e, int i)
	{
		switch(e.type)
		{
			case TELEPORT:
				return e.attr3 == i;
			default:
				return false;
		}
	}
}

