#include "sspgame.h"

namespace game
{
	void renderplayer(sspent *d, const char *mdl)
	{
		int lastaction = d->lastaction,
			anim = ANIM_ATTACK1+d->gunselect,
			delay = 300,
			hold = ANIM_HOLD1|ANIM_LOOP;

		if(intermission && d->state!=CS_DEAD)
		{
			if (secsremain)
				hold = anim = ANIM_WIN|ANIM_LOOP;
			else
				hold = anim = ANIM_LOSE|ANIM_LOOP;
		}
		modelattach a[4];
		int ai = 0;
		if(d->state==CS_ALIVE)
		{
			if(pickups[PICKUP_WEAPON].inrange(d->gunselect))
			{
				a[ai].m = NULL;
				a[ai].name = pickups[PICKUP_WEAPON][d->gunselect]->attachmdl;
				a[ai].tag = "tag_weapon";
				a[ai].anim = ANIM_VWEP_IDLE|ANIM_LOOP;
				a[ai].basetime = 0;
				ai++;
			}
			if(pickups[PICKUP_ARMOUR].inrange(d->armourvec))
			{
				a[ai].m = NULL;
				a[ai].name = pickups[PICKUP_ARMOUR][d->armourvec]->attachmdl;
				a[ai].tag = "tag_shield";
				a[ai].anim = ANIM_VWEP_IDLE|ANIM_LOOP;
				a[ai].basetime = 0;
				ai++;
			}
			if(d->powerup>=0)
			{
				//TODO
				//ai++;
			}
		}
		a[ai].name = NULL;

		if(d->lastpain + 2000 > lastmillis && (lastmillis % 100) > 50) return; //flicker if hurt
		renderclient(d, mdl, a[0].tag ? a : NULL, hold, anim, delay, lastaction, intermission ? 0 : d->lastpain, 1.0f, true);
	}

	void rendergame(bool mainpass)
	{
		startmodelbatches();
		if(isthirdperson()) renderplayer(player1, "rc");
		rendermonsters();
		entities::renderentities();
		renderprojs();
		endmodelbatches();
	}
}
