#include "sspgame.h"

namespace game
{
	vector<proj *> projs;
	vector<projectile *> projectiles;
	
	ICOMMAND(addproj, "siiiii", (const char *s, int *u, int *w, int *x, int *y, int *z), projs.add(new proj(s, *u, *w, *x, *y, *z)));
	ICOMMAND(resetprojs, "", (), projs.setsizenodelete(0););
	
	void setprojdecal(int *idx, int *rad, int *col)
	{
		if(!projs.length()) {conoutf("Error: no projectiles defined, define some with /addproj"); return;}
		
		proj &p = *projs[projs.length()-1];
		p.didx = *idx;
		p.drad = *rad;
		p.dcol = bvec((*col&0xFF0000)/0x010000, (*col&0x00FF00)/0x000100, *col&0xFF);
	}
	COMMAND(setprojdecal, "iii");
	
	void addproj(int p, sspent *d)
	{
		if(!projs.inrange(p)) return;
		
		projectiles.add(new projectile(p, vec(d->o.x, d->o.y, d->o.z - d->eyeheight/2), d->yaw, atan2(d->vel.z+d->falling.z, projs[p]->speed)/RAD));
	}
	
	
	void clearprojs()
	{
		projectiles.setsize(0);
	}

	void updateprojs()
	{
		if(player1->attacking && pickups[PICKUP_WEAPON].inrange(player1->gunselect))
		{
			pickup &p = *pickups[PICKUP_WEAPON][player1->gunselect];
			if(player1->shootmillis + p.cooldown < lastmillis)
			{
				player1->shootmillis = lastmillis;
				addproj(p.projectile, player1);
				playsound(p.sound, &player1->o);
			}
		}
		loopv(projectiles)
		{ //do simplistic flying first, add gravity effects, timers, and so forth, later
			projectile &p = *projectiles[i];
			proj &prj = *projs[p.prj];

			if(prj.speed>2000) //assume bullet-ish for high speeds
			{
				vec pos = p.o;
				raycubepos(pos, p.d, p.o, 0, RAY_CLIPMAT|RAY_ALPHAPOLY);
				adddecal(prj.didx, p.o, p.d.neg(), prj.drad, prj.dcol);
				//insert destroy effects here
				projectiles.remove(i); i--;
			}
			else if(prj.speed>500) //lower speeds means it's rocketish
			{
				
				vec v = p.d;
				v.mul(projs[p.prj]->speed); //assume nothing silly happened to bork this and cause a crash
				v.mul((float)curtime/1000); //would be silly to have the full velocity apply every 1 ms :P
				
				vec tmp;
				raycubepos(p.o, p.d, tmp, 0, RAY_CLIPMAT|RAY_ALPHAPOLY);
				tmp.sub(p.o);

				if(v.magnitude() < tmp.magnitude())
				{
					p.o.add(v);
				}
				else
				{
					p.o.add(tmp);
					adddecal(prj.didx, p.o, p.d.neg(), prj.drad, prj.dcol);
					projectiles.remove(i); i--;
				}
			}
			else if(prj.speed) //hand grenad -ish, bouncers, they are affected by jumppads
			{
				conoutf("hand grenade physics not implemented yet, deleting proj");
				projectiles.remove(i); i--;
			}
			else //mines or traps
			{
				conoutf("mines and traps not done yet, deleting proj"); //need a timer, 15 seconds?
				projectiles.remove(i); i--;
			} 
		}
	}
	
	void renderprojs()
	{
		loopv(projectiles)
		{
			projectile &p = *projectiles[i];
			float yaw, pitch;
			vectoyawpitch(p.d, yaw, pitch);
			
			rendermodel(NULL, projs[p.prj]->mdl, 0, p.o, yaw, pitch, MDL_SHADOW);
		}
	};
	
	void adddynlights()
	{
	
	}
	
	void writeprojectiles(stream *f)
	{
		f->printf("resetprojs\n\n");
		loopv(projs)
		{
			proj &p = *projs[i];
			f->printf("addproj %s %i %i %i %i %i\n", p.mdl, p.damage, p.radius, p.force, p.travelsound, p.speed);
			f->printf("setprojdecal %i %i 0x%.2X%.2X%.2X\n", p.didx, p.drad, p.dcol.x, p.dcol.y, p.dcol.z);
		}
	}
}

