// SauerMod - MODENGINE - Engine Extensions by Quinton Reeves
// This extends the engine core.

#define MODVERSION			30

#define RENDERPUSHX			8.0f
#define RENDERPUSHZ			0.1f

#define COL_WHITE			0xFFFFFF
#define COL_BLACK			0x000000
#define COL_GREY			0x897661
#define COL_YELLOW			0xB49B4B
#define COL_ORANGE			0xB42A00
#define COL_RED				0xFF1932
#define COL_LRED			0xFF4B4B
#define COL_BLUE			0x3219FF
#define COL_LBLUE			0x4BA8FF
#define COL_GREEN			0x32FF64
#define COL_CYAN			0x32FFFF
#define COL_FUSCHIA			0xFFFF32

#define COL_TEXTBLUE		0x6496FF
#define COL_TEXTYELLOW		0xFFC864
#define COL_TEXTRED			0xFF4B19
#define COL_TEXTGREY		0xB4B4B4
#define COL_TEXTDGREEN		0x1EC850

#define COL_FIRERED			0xFF8080
#define COL_FIREORANGE		0xA0C080
#define COL_FIREYELLOW		0xFFC8C8
#define COL_WATER			0x3232FF
#define COL_BLOOD			0x19FFFF

#define CARDTIME			2000	// title card duration
#define CARDFADE			1500	// title card fade in/out

typedef hashtable<char *, ident> idt;
extern idt *idents;

#define _CVAR(t, ts, sv, tv, n, m, c, x, b) \
	static struct var_##n : tident<t> { \
		var_##n(ts) : tident<t>(ID_VAR, #n, m, c, x, &_val) { \
			self = (t *)sv; \
			addident(_name, (ident *)this); \
		} \
		~var_##n() { } \
		b; \
	} ivar_##n tv;

#define CVAR(t, n, m, c, x)  _CVAR(t, t *_s, _s, (this), n, m, c, x, )
#define CVARF(t, n, m, c, x, b) _CVAR(t, t *_s, _s, (this), n, m, c, x, void changed() { b; })

#define CVSET(n,c) \
	{ if (getident(#n)) *(getident(#n))->_storage = c; }
#define CVGET(n) \
	((getident(#n)) ? *(getident(#n))->_storage : 0)

#define _SCOMMAND(t, ts, sv, tv, n, v, g, b) \
	struct cmd_##n : tident<t> \
	{ \
		int _mode; \
		cmd_##n(ts) : tident<t>(ID_ICOMMAND, #n, g, NULL, sv, true) \
		{ \
			_mode = v; \
			addident(_name, (ident *)this); \
		} \
		void run(char **args) { b; } \
	} icom_##n tv;
#define SCOMMAND(t, n, v, g, b) _SCOMMAND(t, t *_s, _s, (this), n, v, g, b)

#define _dbg_ fprintf(stderr, "%s:%d:%s\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);

enum
{
	CN_LEFT = 0,
	CN_RIGHT,
	CN_CENTER,
	CN_MAX
};
#define CON_LEFT		0x0001
#define CON_RIGHT		0x0002
#define CON_CENTER		0x0004

#define CON_CONTINUE	0x0020
#define CON_HILIGHT		0x0020

struct cline { char *cref; int outtime; };
extern vector<cline> conlines[CN_MAX], cntrlines;

enum							// cube empty-space materials
{
	MT_AIR = 0,				// the default, fill the empty space with air
	MT_WATER,				  // fill with water, showing waves at the surface
	MT_CLIP,					// collisions always treat cube as solid
	MT_GLASS,				  // behaves like clip but is blended blueish
	MT_NOCLIP,				 // collisions always treat cube as empty
	MT_LAVA,					// fill with lava
	MT_EDIT					// basis for the edit volumes of the above materials
};

enum
{
	AL_LEFT = 0,
	AL_CENTER,
	AL_RIGHT
};

enum
{
	MN_BACK = 0,
	MN_INPUT,
	MN_MAX
};

// engine imports
extern int efocus, enthover, entorient, showentdir, showentradius;
extern int hidehud, hidestats, hudblend, particletext, maxparticledistance;
extern int thirdperson, thirdpersondistance, thirdpersonheight, thirdpersonscale, thirdpersonstick;
extern int fullbright, fullbrightlevel, grabmouse;
extern string cgzname, bakname, pcfname, mcfname, picname;
extern vector<int> entgroup;

extern void newentity(int type, int a1, int a2, int a3, int a4);
extern void newentity(vec &v, int type, int a1, int a2, int a3, int a4);

extern void getwatercolour(uchar *wcol);
extern void getlavacolour(uchar *lcol);

extern bool menuactive();

// modengine
extern bool modexec(char *name, bool quiet = false);
extern FILE *modfopen(char *name, char *mode);

extern int modgetint(gzFile f);
extern void modputint(gzFile f, int x);

extern bool modoption(char *opt);
extern void modconfig();

extern char *modgettitle();
extern int modgetmat(float x, float y, float z);

// modrender
extern void renderprimitive(bool on);
extern void renderline(vec &fr, vec &to, float r = 255.f, float g = 255.f, float b = 255.f);
extern void rendertris(vec &fr, float yaw, float pitch, float size = 1.f, float r = 255.f, float g = 255.f, float b = 255.f, bool fill = true);
extern void renderlineloop(vec &o, float height, float xradius, float yradius, float z = 255.f, int type = 0, float r = 255.f, float g = 255.f, float b = 255.f);

extern void renderentdir(vec &o, float yaw, float pitch);
extern void renderentradius(vec &o, float height, float radius);

extern bool rendericon(const char *icon, int x, int y, int xs = 120, int ys = 120);

extern bool modlos(vec &o, vec &q, float yaw, float pitch, float mdist = 0.f, float fx = 0.f, float fy = 0.f);
extern bool modsight(physent *d, vec &q, vec &v, float mdist, float fx = 0.f, float fy = 0.f);

extern bool titlecard(int ox, int oy, int secs);

// modpart
extern void part_textf(const vec &s, char *t, bool moving, int fade, int color, ...);
extern void part_text(const vec &s, char *t, bool moving, int fade, int color);

extern void part_splash(int type, int num, int fade, const vec &p, int color);
extern void part_trail(int type, int fade, const vec &s, const vec &e, int color);
extern void part_meter(const vec &s, float val, int type, int fade, int color);
extern void part_flare(const vec &p, const vec &dest, int fade, int type, int color);
extern void part_fireball(const vec &dest, float max, int type, int color);
extern void part_firerad(const vec &dest, float size, int type, int color);
extern void part_spawn(const vec &o, const vec &v, float z, uchar type, int amt, int fade, int color);

// modtext
extern void draw_textx(const char *fstr, int left, int top, int r, int g, int b, int a, int align, ...);
extern bool pushfont(char *name);
extern bool popfont(int num);

// modcon
extern void console(const char *s, int type, ...);

