// SauerMod - TMPGAME - Kart Racing Simulator by Quinton Reeves
// This is the primary tmp game module.

#include "pch.h"
#include "cube.h"

#include "iengine.h"
#include "igame.h"

#include "tmpgame.h"

struct tmpclient : igameclient
{
	#include "tmprender.h"
	#include "tmpents.h"

    tmpentities		et;
    tmpdummycom		cc;

    cament *camera;
    tmpent *player1;
	
	IVAR(showdebug, 0, 1, 1);

	string mapname;

    tmpclient() : et(*this), camera(new cament()), player1(new tmpent()) { }
    ~tmpclient() { }

    char *getclientmap() { return mapname; }
    icliententities *getents() { return &et; }
    iclientcom *getcom() { return &cc; }

    char *gameident() { return "tmp"; }
	char *gamepakdir() { return "mod/data/packages/tmp"; }

	char *defaultmap() { return "start"; }

	char *savedconfig() { return "config.cfg"; }
	char *defaultconfig() { return "defaults.cfg"; }
	char *autoexec() { return "autoexec.cfg"; }
	char *savedservers() { return "servers.cfg"; }

	float stairheight(physent *d) { return 4.1f; }
	float floorz(physent *d) { return 0.867f; }
	float slopez(physent *d) { return 0.5f; }
	float wallz(physent *d) { return 0.2f; }
	float jumpvel(physent *d) { return 125.f; }
	float gravity(physent *d) { return 200.f; }
	float stepspeed(physent *d) { return 1.0f; }
	float watergravscale(physent *d) { return 6.0f; }
	float waterfric(physent *d) { return 20.f; }
	float slopefric(physent *d) { return 6.f; }
	float surfric(physent *d) { return 30.f; }

	vec feetpos(physent *d)
	{
		if (d->type == ENT_PLAYER || d->type == ENT_AI)
			return vec(d->o).sub(vec(0, 0, d->eyeheight-1));
		
		return vec(d->o);
	}

	void updateplayer(tmpent *d)
	{
		int move = d->move, strafe = d->strafe;
		
		if (d->type == ENT_PLAYER)
		{
			moveplayer(d, 20, true);
		}
	}

    void updateworld(vec &pos, int ct, int lm)
    {
		if(!curtime) return;
		
		physicsframe();
		updateplayer(player1);
    }
	
    void initclient() {}
    void physicstrigger(physent *d, bool local, int floorlevel, int waterlevel) {}
    void edittrigger(const selinfo &sel, int op, int arg1 = 0, int arg2 = 0, int arg3 = 0) {}
	void worldhurts(physent *d, int damage) {}
	void newmap(int size) {}
	
    int numdynents() { return 1; }
    dynent *iterdynents(int i)
	{
		if (!i) { return player1; } i--;
		return NULL;
	}

    void resetgamestate() {}
	void startmap(const char *name)
	{
		player1->o = vec(getworldsize()*0.5f, getworldsize()*0.5f, getworldsize());
	}

    bool canjump() { return !menuactive(); }
    void doattack(bool on) {}

    void writegamedata(vector<char> &extras) {}
    void readgamedata(vector<char> &extras) {}

	void loadconfig() {}
	void saveconfig() {}

	void loadworld(const char *name) {}
	void saveworld(const char *name) {}
};

REGISTERGAME(tmpgame, "tmp", new tmpclient(), new tmpdummyserver());
